(function (document, $) {
    $('#message').bind('keydown', function (event) {
        if (event.ctrlKey || event.metaKey) {
            switch (String.fromCharCode(event.which).toLowerCase()) {
                case 'q':
                    event.preventDefault();
                    $(this).selection('insert', {
                        text: '[quote]',
                        mode: 'before'
                    }).selection('insert', {text: '[/quote]', mode: 'after'});
                    break;
                case 'p':
                    event.preventDefault();
                    $(this).selection('insert', {
                        text: '[phpcode]',
                        mode: 'before'
                    }).selection('insert', {text: '[/phpcode]', mode: 'after'});
                    break;
                case 'j':
                    event.preventDefault();
                    $(this).selection('insert', {
                        text: '[jscode]',
                        mode: 'before'
                    }).selection('insert', {text: '[/jscode]', mode: 'after'});
                    break;
                case 'h':
                    event.preventDefault();
                    $(this).selection('insert', {
                        text: '[htmlcode]',
                        mode: 'before'
                    }).selection('insert', {text: '[/htmlcode]', mode: 'after'});
                    break;
                case 'b':
                    event.preventDefault();
                    $(this).selection('insert', {text: '[b]', mode: 'before'}).selection('insert', {
                        text: '[/b]',
                        mode: 'after'
                    });
                    break;
                case 'i':
                    event.preventDefault();
                    $(this).selection('insert', {text: '[i]', mode: 'before'}).selection('insert', {
                        text: '[/i]',
                        mode: 'after'
                    });
                    break;
                case 'm':
                    event.preventDefault();
                    $(this).selection('insert', {
                        text: '[mail]',
                        mode: 'before'
                    }).selection('insert', {text: '[/mail]', mode: 'after'});
                    break;
            }
        }
    });
})(document, HDP.jQuery);