<?php

interface  validation
{
    function dovalidation();
}

class default_personalinfo implements validation
{
    public function dovalidation()
    {
        $this->app= JFactory::getApplication();
        $personalInfo= $this->app->input->get('jform',array(), 'array');
        $this->app->setUserState('data.personalinfo', $personalInfo);
        return true;
    }

}

class default_policy implements validation
{
    public function dovalidation()
    {
        $this->app= JFactory::getApplication();
        $data= $this->app->input->get('jform',array(), 'array');
        return true;
    }

}
class default_payment implements validation
{
    public function dovalidation()
    {

        $this->app= JFactory::getApplication();
        $payment_method= $this->app->input->post->get('payment_method');
        $strategy= new strategy();

        if ($payment_method)
            $strategy->do_request();
        else
            $verify_result= $strategy->do_verify();




        if ($verify_result)
            return true;

        return false;

    }

}

class reserve
{


    public function __construct()
    {
        defined('_JEXEC') or die('Restricted access');
        $this->app= JFactory::getApplication();

        $payment_method_from_qs= $this->app->input->get->get('payment_method');
        if (!$payment_method_from_qs)
            JSession::checkToken('post') or die('invalid token');


        $layout= $this->getLayout();
        $obj = new $layout;
        $result= $obj->dovalidation();

        if ($result)
            $this->nextStep();

        $this->app->redirect((string)JUri::getInstance());
//        $this->app->redirect(JRoute::_('index.php?option=com_reservation&view=reserve'));
    }

    private function getLayout()
    {
        require_once JPATH_SITE.'/components/com_reservation/controllers/reserve.php';

        $controller = new ReservationControllerReserve;
        return $controller->getLayout();

    }

    private function nextStep()
    {
        $function_to_be_executed= $this->app->getUserState('function_to_be_executed',0);
        $this->app->setUserState('function_to_be_executed',++$function_to_be_executed);
    }

}

interface payment
{
    function request();
    function verify();
}


class zarinpal implements payment
{
    public function __construct()
    {

        require_once JPATH_ADMINISTRATOR . '/components/com_reservation/models/reserve.php';

        $this->app= JFactory::getApplication();
        $this->user= JFactory::getUser();
        $this->aid= $this->app->input->get('aid');
        $this->uid= $this->app->input->get('uid');
        $this->params= JComponentHelper::getParams('com_reservation');
        $this->full_price= 12000;
        $this->doctor_quota= 60;
        $this->system_quota= 40;
    }

    function request()
    {

        $sickid= ReservationHelper::exist('#__reservation_sick', 'userid', $this->user->id);

        $data = array(
            'sickid' => $sickid,
            'full_price' => $this->full_price,
            'doctor_quota' => $this->full_price * ($this->doctor_quota/100),
            'system_quota' => $this->full_price * ($this->system_quota/100),
            'appointmentid' => $this->aid,
            'status' =>  'created'
        );

        $reserve= new ReservationModelReserve;
        if (!$reserve->save($data))
            return false;

        $reserve_id= $reserve->getState('reserve.id');

        $requestUrl = 'https://sandbox.zarinpal.com/pg/services/WebGate/wsdl';
        $client = new SoapClient($requestUrl, ['encoding' => 'UTF-8']);
        $result = $client->PaymentRequest(
            [
                'MerchantID' => "aaaaaaaabaaaabaaaabaaaacaaaaaaaaaaaa",
                'Amount' => $this->full_price,
                'Description' => "خرید تست",
                'CallbackURL' => "http://www.lmsyaran.ir/index.php?option=com_reservation&view=reserve_appointment&payment_method=zarinpal&aid=".$this->aid."&uid=".$this->uid."&reserveid=".$reserve_id,
            ]
        );


        if ($result->Status == 100) {

            header('Location: https://sandbox.zarinpal.com/pg/StartPay/' . $result->Authority);
            exit();
        }
    }

    function verify()
    {

        $Authority= $this->app->input->get->get('Authority');
        $statue= $this->app->input->get('Status');
        $reserve_id= $this->app->input->get('reserveid');
        $data= array(
            'id' => $reserve_id,
            'status' => 'confirmed'
        );


        if ($Authority)
        {
            $requestUrl = 'https://sandbox.zarinpal.com/pg/services/WebGate/wsdl';
            $client = new SoapClient($requestUrl, ['encoding' => 'UTF-8']);
            $result = $client->PaymentVerification(
                [
                    'MerchantID' => 'aaaaaaaabaaaabaaaabaaaacaaaaaaaaaaaa',
                    'Authority' => $Authority,
                    'Amount' => $this->full_price,
                ]
            );

            $uri= JUri::getInstance();
            $uri->delVar('Authority');
            $uri->delVar('payment_method');
            $uri->delVar('Status');

            if ($statue== 'OK')
            {
                if ($result->Status== 100)
                {

                    $reserve = new ReservationModelReserve;
                    $reserve->save($data);

                    return true;
                }
            }
        }

        $this->app->enqueueMessage('پرداخت شما با شکست روبرو شد . لطفا دوباره عمل پرداخت را انجام دهید', 'warning');
        return false;


    }
}

class strategy
{
    public function do_request()
    {
        $this->app= JFactory::getApplication();
        $this->payment_method= $this->app->input->post->get('payment_method', 'zarinpal');
        if (class_exists($this->payment_method))
        {
            $object = new $this->payment_method;
            if ($object instanceof payment)
                $object->request();
        }


    }
    public function do_verify()
    {
        $this->app= JFactory::getApplication();
        $this->payment_method= $this->app->input->get->get('payment_method', 'zarinpal');
        if (class_exists($this->payment_method))
        {
            $object = new $this->payment_method;
            if ($object instanceof payment)
                return $object->verify();


        }


    }
}