<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/lmsyaran/public_html/templates/g5_hydrogen/custom/particles/jlparticlejs.yaml',
    'modified' => 1589206722,
    'data' => [
        'name' => 'JL ParticleJS',
        'description' => 'This atom help you create particles for background style.',
        'type' => 'atom',
        'icon' => 'fa-bars',
        'form' => [
            'overrideable' => false,
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable to the particles.',
                    'default' => true
                ],
                'hover' => [
                    'type' => 'select.select',
                    'label' => 'On Hover',
                    'description' => 'Select Hover styles.',
                    'default' => 'grab',
                    'options' => [
                        'none' => 'None',
                        'push' => 'Push',
                        'bubble' => 'Bubble',
                        'repulse' => 'Repulse'
                    ]
                ],
                'click' => [
                    'type' => 'select.select',
                    'label' => 'On Click',
                    'description' => 'Select Click styles.',
                    'default' => 'none',
                    'options' => [
                        'none' => 'None',
                        'push' => 'Push',
                        'remove' => 'Remove',
                        'bubble' => 'Bubble',
                        'repulse' => 'Repulse'
                    ]
                ],
                'items' => [
                    'type' => 'collection.list',
                    'array' => true,
                    'label' => 'Items',
                    'description' => 'Create each item to appear in the content row.',
                    'value' => 'name',
                    'ajax' => true,
                    'fields' => [
                        '.element' => [
                            'type' => 'input.text',
                            'label' => 'Section ID',
                            'description' => 'Enter your unique Section id for creating particles.'
                        ],
                        '.style' => [
                            'type' => 'select.select',
                            'label' => 'Style',
                            'description' => 'Choose the preset style.',
                            'default' => 1,
                            'options' => [
                                1 => 'Default',
                                2 => 'Polygon',
                                3 => 'Snowdrop',
                                4 => 'Custom'
                            ]
                        ],
                        '.number' => [
                            'type' => 'input.number',
                            'label' => 'Number',
                            'description' => 'Enter the number of particles. Default - 70, Polygon - 8, SnowDrop - 490.',
                            'default' => 70
                        ],
                        '.speed' => [
                            'type' => 'input.number',
                            'label' => 'Speed',
                            'description' => 'Enter the speed of particles movement. Default - 5, Polygon - 8, SnowDrop - 1.',
                            'default' => 5
                        ],
                        '.outmode' => [
                            'type' => 'select.select',
                            'label' => 'Out mode',
                            'description' => 'Choose the mode when particles touch the edge.',
                            'default' => 'out',
                            'options' => [
                                'out' => 'Out',
                                'bounce' => 'Bounce'
                            ]
                        ],
                        '.zindex' => [
                            'type' => 'input.number',
                            'label' => 'Z-index',
                            'description' => 'Enter the z-index css for particles. An element with higher z-index is always in front of lower element.',
                            'default' => 99
                        ],
                        'config_intro' => [
                            'type' => 'separator.note',
                            'class' => 'alert alert-info',
                            'content' => 'Create custom <a href="https://vincentgarreau.com/particles.js/" target="_blank">ParticleJS Configuration <i class="fa fa-fw fa-external-link" aria-hidden="true"></i></a> and add json code below.'
                        ],
                        '.custom' => [
                            'type' => 'textarea.textarea',
                            'label' => 'Custom Json code',
                            'description' => 'Configure, export, and add your particles.js configuration here.'
                        ]
                    ]
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-success',
                    'content' => 'JL ParticleJS <strong>Version: 2.1.3</strong> Copyright (C) <a href="https://joomlead.com/" target="_blank">https://joomlead.com</a> | <a href="https://joomlead.com/g5/docs/particlejs-atom-documentation/" target="_blank">Documentation</a>'
                ]
            ]
        ]
    ]
];
