<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		doctorsignup.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Doctorsignup Controller
 */
class ReservationControllerDoctorsignup extends JControllerForm
{
	/**
	 * Current or most recently performed task.
	 *
	 * @var    string
	 * @since  12.2
	 * @note   Replaces _task.
	 */
	protected $task;

	public function __construct($config = array())
	{
		$this->view_list = 'login'; // safeguard for setting the return view listing to the default site view.
		parent::__construct($config);
	}


/***[JCBGUI.site_view.php_controller.34.$$$$]***/
    public function signup()
    {


        $app= JFactory::getApplication();

        if(!JFactory::getUser()->guest)
        {
            $app->enqueueMessage('برای ساخت حساب جدید ابتدا از حساب فعلی خود خارج شوید','warning');
            $app->redirect(JUri::root());
        }



        $uri = (string)JUri::getInstance();
        JLoader::register('ReservationModelDoctor', JPATH_COMPONENT_ADMINISTRATOR.'/models/doctor.php');
        \JForm::addFormPath(JPATH_COMPONENT_ADMINISTRATOR . '/models/forms');
        $data= JFactory::getApplication()->input->get('jform',array(),'array');

        $doctorsModel= new ReservationModelDoctor;
        $form = $doctorsModel->getForm($data, false);

        $xml = new SimpleXMLElement('<field name="password" validate="password"/>');
        $form->setField($xml);

//    $rule= JFormHelper::loadRuleType('password');
//    $res= $rule->test($xml,$data['password']);

//    $filteredData = $form->filter($data);

        $filter= JFilterInput::getInstance();


        $data['name']=  preg_replace('/[0-9]+/', '', $data['name']);
        $data['msn']= $filter->clean( $data['msn'], 'int');


        $model= $this->getModel();
        if($model->checkPhoneExist($data['phonenumber']))
        {
            $app->enqueueMessage('این شماره تلفن قبلا در این سامانه ثبت شده است لطفا با شماره تلفن دیگری ثبت نام کنید','warning');
            $app->setUserState('doctor.data',$data);
            $app->redirect($uri);
        }

        $validData = $doctorsModel->validate($form, $data);
        if ($validData === false)
        {
            $errors = $doctorsModel->getErrors();

            foreach ($errors as $error) {
                $app->enqueueMessage($error->getMessage(),'warning');
            }
            $app->setUserState('doctor.data',$data);
            $app->redirect($uri);
        }
        else{

            $userdata = array(
                "name"=> $data['name'],
                "username"=> $data['phonenumber'],
                "password"=> $data['password'],
                "password2"=> $data['password'],
                "email"=> 'R_'.$data['phonenumber'].'@gmail.com',
                "block"=> 0,
            );


            $userGroup = 2;


            $userdata["groups"] = array($userGroup);
            $user = new JUser;


            if(!$user->bind($userdata)) {
                $app->enqueueMessage($user->getError(), 'warning');
                $app->redirect($uri);

            }

            if (!$user->save()) {
                $app->enqueueMessage($user->getError(), 'warning');
                $app->redirect($uri);

            }

            $app->setUserState('doctor.data',$data);

            $userId= $user->id;

            $doctorInfo= array(
                'userid'=> $userId,
                'msn' => $data['msn'],
                'catid' => $data['catid'],
                'capitalid' => $data['capitalid'],
                'cityid' => $data['cityid'],
                'phonenumber' => $data['phonenumber'],
                'officephone' => $data['officephone'],
                'address' => $data['address'],
            );

            if(!$doctorsModel->save($doctorInfo))
            {
                $app->enqueueMessage('اطلاعات خود را تصحیح کرده و سپس وارد نمایید', 'warning');
                $app->redirect($uri);
            }
            $app->setUserState('doctor.data','');




            echo 'user saved successfully';


        }

        $credentials = array();
        $credentials['username'] = $data['phonenumber'];
        $credentials['password'] = $data['password'];
        $login_site = JFactory::getApplication('site');
        $login_site->login($credentials, $options=array());
        $redirect = JUri::root();
        $login_site->redirect($redirect);

    }/***[/JCBGUI$$$$]***/


	/**
	 * Method to check if you can edit an existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

        /**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	protected function allowAdd($data = array())
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Method to check if you can save a new or existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowSave($data, $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Function that allows child controller access to model data
	 * after the data has been saved.
	 *
	 * @param   JModelLegacy  $model      The data model object.
	 * @param   array         $validData  The validated data.
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
	}
}
