<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		comment.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Comment Controller
 */
class ReservationControllerComment extends JControllerForm
{
	/**
	 * Current or most recently performed task.
	 *
	 * @var    string
	 * @since  12.2
	 * @note   Replaces _task.
	 */
	protected $task;

	public function __construct($config = array())
	{
		$this->view_list = 'login'; // safeguard for setting the return view listing to the default site view.
		parent::__construct($config);
	}


/***[JCBGUI.site_view.php_controller.32.$$$$]***/
public function save($key = NULL, $urlVar = NULL)
{
    $app= JFactory::getApplication();
    $data= $app->input->get('jform',array(),'array');
    $uid= $app->input->get('uid', 0);
    $userid= JFactory::getUser()->get('id', 0);
    $seid= $app->input->get('seid', 0);
    $currentUrl= (string)JUri::getInstance();


    \JPluginHelper::importPlugin('reservation');
    $dispatcher = \JEventDispatcher::getInstance();
    $result= $dispatcher->trigger('onBeforeSaveComment',array($uid,$userid,$seid));


    $data['seid']= $seid;
    $data['sickid']= $result[0]['sickid'];
    $data['consultantid']= $result[0]['consultantid'];
    $data['token']= md5(uniqid(rand(), true));

    JLoader::register('ReservationModelComment',JPATH_COMPONENT_ADMINISTRATOR.'/models/comment.php');
    $commentModel= new ReservationModelComment();
    \JForm::addFormPath(JPATH_COMPONENT_ADMINISTRATOR . '/models/forms');
    $form= $commentModel->getForm($data,false);


    $filterData= $form->filter($data);
    $filterData['published']= 0;
    $validData= $commentModel->validate($form,$filterData);

    if ($validData === false)
    {
        $errors= $commentModel->getErrors();
        foreach ($errors as $error) {
            $app->enqueueMessage($error->getMessage(),'warning');
        }
        $app->setUserState('comment.data',$filterData);
        $app->redirect($currentUrl);
    }

    if($commentModel->save($filterData))
    {
        $app->setUserState('status',1);
        $app->setUserState('comment.data','');
        $app->redirect($currentUrl);
    }


}/***[/JCBGUI$$$$]***/


	/**
	 * Method to check if you can edit an existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

        /**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	protected function allowAdd($data = array())
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Method to check if you can save a new or existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowSave($data, $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Function that allows child controller access to model data
	 * after the data has been saved.
	 *
	 * @param   JModelLegacy  $model      The data model object.
	 * @param   array         $validData  The validated data.
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
	}
}
