<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		view.html.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Reservation View class for the Messages
 */
class ReservationViewMessages extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{		
		// get combined params of both component and menu
		$this->app = JFactory::getApplication();
		$this->params = $this->app->getParams();
		$this->menu = $this->app->getMenu()->getActive();
		// get the user object
		$this->user = JFactory::getUser();
		// Initialise variables.
		$this->item = $this->get('Item');

		// Set the toolbar
		$this->addToolBar();

		// set the document
		$this->_prepareDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode(PHP_EOL, $errors), 500);
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_SITE.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new reservationHeaderCheck;

		// always load these files.
		$this->document->addScript(JURI::root(true) . "/media/com_reservation/pusher/js/pusher.min.js", (ReservationHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");

		// Add View JavaScript File
		$this->document->addScript(JURI::root(true) . "/components/com_reservation/assets/js/messages.js", (ReservationHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");
		
		/***[JCBGUI.site_view.php_document.26.$$$$]***/
				$user= JFactory::getUser()->get('id');
		        $to= $this->item->users_id;
		        $chatAjaxRoute= JRoute::_('index.php?option=com_reservation&view=messages');
		
				$seid= JFactory::getApplication()->input->get('seid');
		        $pid= JFactory::getApplication()->input->get('pid');
		        $uid= JFactory::getApplication()->input->get('uid');
				$channel_Token= $this->get('PrivateChannelToken');
		                
				$this->document->addScriptOptions('seid',$seid);
				$this->document->addScriptOptions('channel_token',$channel_Token);
		
		        $this->document->addScriptOptions('userId',$user);
				$this->document->addScriptOptions('pid',$pid);
		        $this->document->addScriptOptions('chatAjaxRoute',$chatAjaxRoute);
				$this->document->addScriptOptions('uid',$uid);
		        $this->document->addScriptOptions('to',$to);/***[/JCBGUI$$$$]***/
		 
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/components/com_reservation/assets/css/messages.css', (ReservationHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{

		// set help url for this view if found
		$help_url = ReservationHelper::getHelpUrl('messages');
		if (ReservationHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_RESERVATION_HELP_MANAGER', false, $help_url);
		}
		// now initiate the toolbar
		$this->toolbar = JToolbar::getInstance();
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var, $sorten = false, $length = 40)
	{
		// use the helper htmlEscape method instead.
		return ReservationHelper::htmlEscape($var, $this->_charset, $sorten, $length);
	}
}
