<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		default.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


?>
<?php echo $this->toolbar->render(); ?>

<!--[JCBGUI.site_view.default.27.$$$$]-->
<section id="consultantItem">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php?option=com_reservation"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-house-door" viewBox="0 0 16 16">
                            <path d="M8.354 1.146a.5.5 0 0 0-.708 0l-6 6A.5.5 0 0 0 1.5 7.5v7a.5.5 0 0 0 .5.5h4.5a.5.5 0 0 0 .5-.5v-4h2v4a.5.5 0 0 0 .5.5H14a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.146-.354L13 5.793V2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1.293L8.354 1.146zM2.5 14V7.707l5.5-5.5 5.5 5.5V14H10v-4a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5v4H2.5z"/>
                        </svg></a></li>
                <li class="breadcrumb-item active" aria-current="page"> مشاوران </li>
                <li class="breadcrumb-item active" aria-current="page"> <?=  $this->item->users_name; ?> </li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="row">
                <div class="col-12">
                    <div class="card consultantCard" data-uid="<?= $this->item->userid;?>">
                        <div class="card-header">
                            <span style="font-size: 11px;text-decoration: underline;float: left;color:#f3f3f3;cursor: pointer">آموزش مشاوره گرفتن آنلاین</span>
                        </div>
                        <div class="card-body">
                            <div class="block1">
                              <?php
                                  if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
                                    // echo 'CB not installed';
                                    $imgurl = '';
                                  }
                                  else
                                  {
                                    include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );
                                    
                                    cbimport( 'cb.html' );
                                    $joomlaid = $id;
                                    global $_CB_framework, $_PLUGINS, $ueConfig;

                                    $cbUser =& CBuser::getInstance( (int) $this->item->userid );
                                    $user = $cbUser->getUserData();
                                    $imgurl = '/images/comprofiler/' . $user->avatar;
                                    // dump($this, 'this');
                                  }
                                ?>
                            
                            
                            
                                <img src="<?php echo $imgurl; ?>" alt="">
                            </div>
                            <div class="block2">
                                <ul>
                                    <li style="color: #004c72 "><h1><?= $this->item->users_name; ?></h1></li>
                                    <li><?=  $this->item->categories_title; ?></li>
                                    <li>
                                          <?php
                                          $rate= 0;
                                          $cmCount= count($this->item->comments);
                                          foreach ($this->item->comments as $c) {
                                              $rate += $c->rate;
                                              }
                                          $rate= ($rate/$cmCount)*25;
                                          ?>
                                          <span><?= $rate;?>%</span>
                                          -
                                          <span>(<?= $cmCount; ?> نظر)</span>
                                      </li>
                                </ul>
                            </div>
                            <div class="block3">
                                <ul>
                                    <li>
                                        <span>نظام پزشکی : </span>
                                        <span>  <?=  $this->item->msn; ?></span>
                                    </li>
                                    <li>
                                        <span>تجربه : </span>
                                        <span> <?=  $this->item->experience; ?> سال</span>
                                    </li>
                                    <li>
                                        <span>تعداد مشاوره : </span>
                                        <span>  <?=  $this->item->sessionCount; ?> جلسه</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mt-3">
                    <div class="card" style="height: 315px">
                        <div class="card-body" style="display:flex;flex-direction: column;justify-content: space-around">
                            <h5 style="font-size: 14px;font-weight: 600;" class="card-title">درباره من</h5>
                            <div style="height:75%">
                                <p style="color:#004c72" class="card-text"> <?=  $this->item->introduction; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mt-3">
                    <div class="card" style="height:315px">
                        <div class="card-body" style="display:flex;flex-direction: column;justify-content: space-around;">
                            <h5 style="font-size: 14px;font-weight: 600;" class="card-title">ویدئو معرفی من</h5>
                            <div style="height:75%; display:flex; flex-direction: column;justify-content:center;align-items: center">
                                <img src="<?= $this->baseurl;?>/templates/mytemp/assets/images/video-camera.svg" alt="">
                                <p style="color:#ccc">در حال آماده سازی</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card plans">
                <div class="card-body" style="display:flex;flex-direction: column;justify-content: space-around;">
                    <h5 style="font-size: 14px;font-weight: 600;" class="card-title">پلن های مشاوره</h5>

                    <div style="height:75%; display:flex; flex-direction: column;justify-content:center;align-items: center">
                        <ul>
                            <?php foreach ($this->item->plans as $plan): ?>

                                <li data-planid="<?= $plan->id;?>">
                                    <div>
                                <span>
                                    <i><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chat-left-text" viewBox="0 0 16 16">
  <path d="M14 1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H4.414A2 2 0 0 0 3 11.586l-2 2V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12.793a.5.5 0 0 0 .854.353l2.853-2.853A1 1 0 0 1 4.414 12H14a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z"/>
  <path d="M3 3.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zM3 6a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9A.5.5 0 0 1 3 6zm0 2.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
</svg></i>
                                  <?php
                                    $plantype_map= [1=> 'گفتگوی تلفنی با مشاور', 2=> 'گفتگوی متنی با مشاور', 3=> 'گفتگوی ویدیویی با مشاور'];
                                    echo $plantype_map[$plan->plantype];
                                    ?>
                                </span>
                                        <span style="font-size: 12px"><?= $plan->price;?></span>
                                    </div>
                                    <div>
                                <span>
                                    انتظار کمتر از 10 ساعت
                                </span>
                                        <span>
                                    + پایان توافقی گفتگو
                                </span>
                                        <span>
                                    + ‏3 ویژگی
                                </span>
                                    </div>
                                </li>

                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="<?= JRoute::_('index.php?option=com_reservation&view=firstqst&uid='.$this->item->userid.'&pid='.$this->item->plans[0]->id.'',false);?>" id="startCo" class="btn btn-primary">شروع مشاوره</a>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-8">
            <div class="comments mt-5">
                <div class="card-title">
                    نظرات کاربران
                </div>
                <div class="comment">
                   <?php foreach ($this->item->comments as $comment): ?>
                       <div class="card mb-2">
                           <div class="card-header" style="display:flex;justify-content: space-between">
                               <span><?= $comment->name;?></span>
                               <span><?= Joomla\CMS\HTML\HtmlHelper::date($comment->created, 'Y-m-d --- H:i');?></span>
                           </div>
                           <div class="card-body" style="display:flex;justify-content: start">
                               <div class="ml-5">
                                   <img style="width:62px;height:62px;border-radius: 50%;border: 3px solid #ccc;" src="<?= $comment->image;?>" alt="">
                               </div>
                               <div>
                                   <p class="card-text"><?= $comment->text;?></p>
                               </div>
                           </div>
                       </div>
                   <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section><!--[/JCBGUI$$$$]-->

