<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		reserve_appointment.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Reserve_appointment Controller
 */
class ReservationControllerReserve_appointment extends JControllerForm
{
	/**
	 * Current or most recently performed task.
	 *
	 * @var    string
	 * @since  12.2
	 * @note   Replaces _task.
	 */
	protected $task;

	public function __construct($config = array())
	{
		$this->view_list = 'login'; // safeguard for setting the return view listing to the default site view.
		parent::__construct($config);
	}


/***[JCBGUI.site_view.php_controller.36.$$$$]***/
public function default_personalinfo()
{
    $function_to_be_executed= $this->check(__FUNCTION__);
  echo '<pre>';
  var_dump($function_to_be_executed);
  echo '</pre>';
  exit();
}

public function check($funcname)
{
    JSession::checkToken('post') or die;

    $uri= (string)JUri::getInstance();
  
    $app= JFactory::getApplication();
    $params= JComponentHelper::getParams('com_reservation');
    $chekout= $params->get('checkout');
    $function_to_be_executed= $app->getUserState('function_to_be_executed',0);
    $step= 'checkout'.$function_to_be_executed;
    $layout= $chekout->$step->reservetemplate;
    $layout= preg_replace('/\.php$/','',$layout);

    if ($layout != $funcname)
    {
        $app->setUserState('function_to_be_executed',0);
        $app->redirect($uri);
    }

    return ++$function_to_be_executed;
}

public function reserve()
{
    require JPATH_SITE.'/components/com_reservation/helpers/reserve.php';
    $reserve= new reserve();

}
public function reordering($checkout)
    {
        $checkout= (array) $checkout;

        $reordering= [];
        foreach ($checkout as $item) {
            $reordering[]= $item;
        }

        return $reordering;
    }

    public function getLayout()
    {
        $app= JFactory::getApplication();
        $params= JComponentHelper::getParams('com_reservation');
        $chekout= $params->get('checkout');
        $chekout= $this->reordering($chekout);
        $function_to_be_executed= $app->getUserState('function_to_be_executed',0);
        $layout= $chekout[$function_to_be_executed]->reservetemplate;
        $layout= preg_replace('/\.php$/','',$layout);
        return $layout;
    }
  public function back()
    {
        JSession::checkToken('post') or die;
        $app= JFactory::getApplication();
        $function_to_be_executed= $app->getUserState('function_to_be_executed',0);
        $app->setUserState('function_to_be_executed',--$function_to_be_executed);
        $app->redirect(JUri::getInstance());
    }
  public function reset()
    {

        $uri= JUri::getInstance();
        $app= JFactory::getApplication();
        $app->setUserState('function_to_be_executed',0);
        $uri->delVar('start');
        $app->redirect((string)$uri);
    }/***[/JCBGUI$$$$]***/


	/**
	 * Method to check if you can edit an existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

        /**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	protected function allowAdd($data = array())
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Method to check if you can save a new or existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowSave($data, $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Function that allows child controller access to model data
	 * after the data has been saved.
	 *
	 * @param   JModelLegacy  $model      The data model object.
	 * @param   array         $validData  The validated data.
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
	}
}
