<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		ajax.json.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Ajax Controller
 */
class ReservationControllerAjax extends JControllerLegacy
{
	public function __construct($config)
	{
		parent::__construct($config);
		// make sure all json stuff are set
		JFactory::getDocument()->setMimeEncoding( 'application/json' );
		JResponse::setHeader('Content-Disposition','attachment;filename="getajax.json"');
		JResponse::setHeader("Access-Control-Allow-Origin", "*");
		// load the tasks 
		$this->registerTask('saveChat', 'ajax');
		$this->registerTask('conversation', 'ajax');
		$this->registerTask('ajaxReadMessage', 'ajax');
		$this->registerTask('deleteChat', 'ajax');
		$this->registerTask('goToClass', 'ajax');
		$this->registerTask('getCatLevelOne', 'ajax');
		$this->registerTask('getCatLevelTwo', 'ajax');
	}

	public function ajax()
	{
		$user 		= JFactory::getUser();
		$jinput 	= JFactory::getApplication()->input;
		// Check Token!
		$token 		= JSession::getFormToken();
		$call_token	= $jinput->get('token', 0, 'ALNUM');
		if($jinput->get($token, 0, 'ALNUM') || $token === $call_token)
		{
			$task = $this->getTask();
			switch($task)
			{
				case 'saveChat':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$messageValue = $jinput->get('message', NULL, 'RAW');
						$fromValue = $jinput->get('from', NULL, 'STRING');
						$toValue = $jinput->get('to', NULL, 'STRING');
						$seidValue = $jinput->get('seid', NULL, 'INT');
						$pidValue = $jinput->get('pid', NULL, 'INT');
						$replyidValue = $jinput->get('replyid', 0, 'INT');
						$pmidValue = $jinput->get('pmid', 0, 'INT');
						if($messageValue && $user->id != 0 && $fromValue && $toValue && $seidValue && $pidValue)
						{
							$result = $this->getModel('ajax')->saveChat($messageValue, $fromValue, $toValue, $seidValue, $pidValue, $replyidValue, $pmidValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'conversation':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$user1Value = $jinput->get('user1', NULL, 'INT');
						$user2Value = $jinput->get('user2', NULL, 'INT');
						$seidValue = $jinput->get('seid', NULL, 'INT');
						$pidValue = $jinput->get('pid', NULL, 'INT');
						if($user1Value && $user->id != 0 && $user2Value && $seidValue && $pidValue)
						{
							$result = $this->getModel('ajax')->conversation($user1Value, $user2Value, $seidValue, $pidValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'ajaxReadMessage':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$midValue = $jinput->get('mid', NULL, 'INT');
						$seidValue = $jinput->get('seid', NULL, 'INT');
						if($midValue && $user->id != 0 && $seidValue)
						{
							$result = $this->getModel('ajax')->ajaxReadMessage($midValue, $seidValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'deleteChat':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$midValue = $jinput->get('mid', NULL, 'INT');
						if($midValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->deleteChat($midValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'goToClass':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$user1Value = $jinput->get('user1', NULL, 'INT');
						$user2Value = $jinput->get('user2', NULL, 'INT');
						$seidValue = $jinput->get('seid', NULL, 'INT');
						$pidValue = $jinput->get('pid', NULL, 'INT');
						if($user1Value && $user->id != 0 && $user2Value && $seidValue && $pidValue)
						{
							$result = $this->getModel('ajax')->goToClass($user1Value, $user2Value, $seidValue, $pidValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getCatLevelOne':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$extensionValue = $jinput->get('extension', NULL, 'STRING');
						if($extensionValue)
						{
							$result = $this->getModel('ajax')->getCatLevelOne($extensionValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getCatLevelTwo':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$catIdLevel1Value = $jinput->get('catIdLevel1', NULL, 'INT');
						if($catIdLevel1Value)
						{
							$result = $this->getModel('ajax')->getCatLevelTwo($catIdLevel1Value);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
			}
		}
		else
		{
			if($callback = $jinput->get('callback', null, 'CMD'))
			{
				echo $callback."(".json_encode(false).");";
			}
			else
  			{
				echo "(".json_encode(false).");";
			}
		}
	}
}
