/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		doctor.js
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

/* JS Document */

/***[JCBGUI.site_view.javascript_file.35.$$$$]***/
jQuery(document).ready(function ($){

    var $= jQuery
    var userid= Joomla.getOptions('userid')
    var uid= Joomla.getOptions('uid')
    var events= Joomla.getOptions('appoinements')


    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridWeek',
        customButtons: {
            myCustomButton: {
                text: 'custom!',
                click: function() {
                    alert()
                    calendar.addEvent( { // this object will be "parsed" into an Event Object
                        id: 'farhad',
                        editable : 'true',
                        title: 'تایم editable', // a property!
                        start: '2021-05-09', // a property!
                        end: '2021-05-09' // a property! ** see important note below about 'end' **
                    } )
                }
            }
        },
        eventClick: function(info) {


            var close= '<button type="button" class="btn btn-warning" data-dismiss="modal">انصراف</button>';
            if (userid)
            {
                var modal_body= 'آیا از رزرو این نوبت مطمئن هستید ؟'
                var aid= info.event.id
                var link= 'index.php?option=com_reservation&view=reserve_appointment&start=true&uid='+uid+'&aid='+aid+''
                var a= '<a href="'+link+'" class="btn btn-success"> بله </a>'
            }
            else
            {
                var modal_body= 'برای رزرو نوبت ابتدا وارد حساب کاربری خود شوید.'
                var link= 'index.php?option=com_reservation&view=usersign&Itemid=138'
                var a= '<a href="'+link+'" class="btn btn-success"> ورود </a>'
            }


            $('.modal-body').html(modal_body);
            $('.modal-footer').html(close+a);
            $('.modal').modal('show');
            console.log(info.event.id)

            // change the border color just for fun
            info.el.style.borderColor = 'red';
        },
        timeZone: 'Asia/Tehran',
        locale: 'fa',
        direction: 'rtl',
        firstDay: 6,
        views: {
            dayGridWeek: { // name of view
                titleFormat: { year: 'numeric' }
                // other view-specific options here
            }
        },
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'myCustomButton'
        },
        dateClick: function(arg) {
            console.log(arg.date.toString());
        }
    });
    calendar.render();

    // var event = calendar.getEventById('farhad')
    // var start = event.start

    jQuery.each(events,function (index, value){


        calendar.addEvent( {
            id: value.id,
            // editable : 'false',
            title: value.title,
            start: value.apoDate,
            // end:  '2021-03-04'
        } )



    })

    if (jQuery(window).width() < 640)
        calendar.changeView('dayGridDay')

    jQuery(window).resize(function (){
        if (jQuery(window).width() < 640)
            calendar.changeView('dayGridDay')
        else
            calendar.changeView('dayGridWeek')
    })


})/***[/JCBGUI$$$$]***/
