<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		view.html.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Moojla View class for the Coursedetail
 */
class MoojlaViewCoursedetail extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{		
		// get combined params of both component and menu
		$this->app = JFactory::getApplication();
		$this->params = $this->app->getParams();
		$this->menu = $this->app->getMenu()->getActive();
		// get the user object
		$this->user = JFactory::getUser();
		// Initialise variables.
		$this->item = $this->get('Item');
		
		/***[JCBGUI.site_view.php_jview_display.38.$$$$]***/
		$params = JComponentHelper::getParams('com_moojla');
		
		if($this->item->templatestyle == 0)
		{
		  $templateStyleId = trim($params->get('course_templatestyle'));
		}
		else
		{
		  $templateStyleId = $this->item->templatestyle;
		}
		$app = JFactory::getApplication();
		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_templates/tables');
		$tmplStyle = JTable::getInstance('Style', 'TemplatesTable');
		$tmplStyle->load($templateStyleId);
		
		if (!empty($tmplStyle->template)){
		  $app->setTemplate($tmplStyle->template, $tmplStyle->params);
		}
		
		
		$this->course = new stdClass();
		if($this->item)
		  $this->course = clone($this->item);
		$user = JFactory::getUser();
		
		$this->enrolState = false;
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('mid'));
		$query->from($db->quoteName('#__moojla_user_map'));
		$query->where($db->quoteName('jid') . ' = ' . $db->quote($user->id));
		$db->setQuery($query);
		$this->moodleuserid = $db->loadResult();
		
		if($this->moodleuserid)
		{
		  $db = JFactory::getDbo();
		  $query = $db->getQuery(true);
		  $query->select($db->quoteName('id'));
		  $query->from($db->quoteName('#__moojla_enrolment'));
		  $query->where($db->quoteName('moojlacourse') . ' = ' . $db->quote($this->course->remoteid));
		  $query->where($db->quoteName('jid') . ' = ' . $db->quote($user->id));
		  $query->where($db->quoteName('published') . ' = 1');
		  $db->setQuery($query);
		  $is_enrolled = $db->loadResult();
		  if($is_enrolled)
		    $this->enrolState = true;
		}
		unset($this->course->remoteidCourseidSectionB);
		$this->course->sections = $this->item->remoteidCourseidSectionB;
		if(is_object($this->item->remoteidCourseidSectionB))
		{
		  if(property_exists($this->item->remoteidCourseidSectionB, 'exception'))
		  {
		    $this->app->enqueueMessage(JText::_($this->item->remoteidCourseidSectionB->message));
		    $this->app->redirect('index.php');
		  }
		}
		if($this->item->remoteidCourseidSectionB)
		{
		  foreach($this->item->remoteidCourseidSectionB as $sindex => $section)
		  {
		    $this->course->sections[$sindex] = clone $section;
		    $this->course->sections[$sindex]->modules = $section->section_idModule_section_idModuleC;
		    unset($this->course->sections[$sindex]->section_idModule_section_idModuleC);
		    if($section->section_idModule_section_idModuleC)
		    {
		      if($this->course->availabilityinfolink == 2)
		        $availabilityinfolink = $params->get('availabilityinfolink', 0);
		      else
		        $availabilityinfolink = $this->course->availabilityinfolink;
		      
		      if(property_exists($section, "availabilityinfo") && !$availabilityinfolink)
		      {
		        $HTMLText = $section->availabilityinfo;
		        $ClearText = html_entity_decode(strip_tags($HTMLText));
		        $ClearText = preg_replace( "/\n\s+/", "\n", $ClearText);
		        $ClearText = preg_replace( "/\s+/", " ", $ClearText);
		        $this->course->sections[$sindex]->availabilityinfo = $ClearText;
		      }
		
		      $availableflag = -1;
		      $availableclass = -1;
		      if($this->enrolState)
		      {
		        if($section->uservisible)
		        {
		          $availableflag = 0;
		          $availableclass = 'availablity-enroled-visible';
		        }
		        else
		        {
		          $availableflag = 1;
		          $availableclass = 'availablity-enroled-notvisible';
		        }
		      }
		      else
		      {
		        if($section->uservisible)
		        {
		          $availableflag = 2;
		          $availableclass = 'availablity-notenroled-visible';
		        }
		        else
		        {
		          if(!$this->course->guest)
		          {
		            $availableclass = 'availablity-notenroled-notvisible';
		            $availableflag = 3;
		          }
		          else
		          {
		            $availableflag = 1;
		            $availableclass = 'availablity-notenroled-visible';
		          }
		        }
		      }
		
		      $this->course->sections[$sindex]->availableflag = $availableflag;
		      $this->course->sections[$sindex]->availableclass = $availableclass;
		
		      foreach($section->section_idModule_section_idModuleC as $mindex => $module)
		      {
		        $this->course->sections[$sindex]->modules[$mindex] = clone $module;
		        $moodleskyroommods = $this->params->get('moodleskyroommods');
		        $directentery = $this->params->get('directentry');
		        if(is_array($moodleskyroommods) && in_array($module->modname, $moodleskyroommods) && $directentery == 1)
		        {
		          $module->url = str_replace("view.php","joinroom.php",$module->url);
		        }
		
		        if($module->modname == "label")
		        {
		          $show_label_contents= trim($this->params->get('show_label_contents'));
		          if(!$show_label_contents)
		          {
		            $this->course->sections[$sindex]->modules[$mindex]->description = JText::_('COM_MOOJLA_ACCESSING_TO_THIS_LABEL_IS_DENIED');
		          }
		          $this->course->sections[$sindex]->modules[$mindex]->name = $this->course->sections[$sindex]->modules[$mindex]->description;
		        }
		
		        $availableflag = -1;
		        $availableclass = -1;
		        if($this->enrolState)
		        {
		          if($module->uservisible)
		          {
		            $availableflag = 0;
		            $availableclass = 'availablity-enroled-visible';
		          }
		          else
		          {
		            $availableflag = 1;
		            $availableclass = 'availablity-enroled-notvisible';
		          }
		        }
		        else
		        {
		          if($module->uservisible)
		          {
		            $availableflag = 2;
		            $availableclass = 'availablity-notenroled-visible';
		          }
		          else
		          {
		            if(!$this->course->guest)
		            {
		              $availableclass = 'availablity-notenroled-notvisible';
		              $availableflag = 3;
		            }
		            else
		            {
		              $availableflag = 0;
		              $availableclass = 'availablity-notenroled-visible';
		            }
		          }
		        }
		        
		        if($section->section == 0)
		        {
		          $availableflag = 0;
		          $availableclass = 'availablity-notenroled-visible';
		        }
		        
		        $this->course->sections[$sindex]->modules[$mindex]->availableflag = $availableflag;
		        $this->course->sections[$sindex]->modules[$mindex]->availableclass = $availableclass;
		
		        if(property_exists($module, "availabilityinfo") && !$availabilityinfolink)
		        {
		          $HTMLText = $module->availabilityinfo;
		          $ClearText = html_entity_decode(strip_tags($HTMLText));
		          $ClearText = preg_replace( "/\n\s+/", "\n", $ClearText);
		          $ClearText = preg_replace( "/\s+/", " ", $ClearText);
		          $this->course->sections[$sindex]->modules[$mindex]->availabilityinfo = $ClearText;
		        }
		
		        $finalurl = str_replace('/webservice/pluginfile.php/', '/auth/moojla/pluginfile_moojla.php/', $module->url);
		        $finalurl = str_replace('/pluginfile.php/', '/auth/moojla/pluginfile_moojla.php/', $finalurl);
		        $this->course->sections[$sindex]->modules[$mindex]->url = $finalurl;
		
		        if(($module->uservisible && $module->url && $this->enrolState) || $this->course->guest)
		        {
		          if($module->modname == "page")
		          {
		            $pmod = current($module->module_idContents_module_idContentD);
		            $purl = $src = str_replace('/webservice/pluginfile.php/', '/auth/moojla/pluginfile_moojla.php/', $pmod->fileurl);
		            $purl = $src = str_replace('?forcedownload=1', '', $purl);
		            $page_course = $this->course;
		            $page_section = $section;
		            $pagetype = $params->get('pagetype');
		            if($pagetype == 0) {
		              $header_arr = [$page_course->cat_name, $page_course->shortname, $page_section->name];
		              $pageheader = implode(' > ', $header_arr) ;
		
		              $dataObj = array(
		                "wsfunction"			=> "moojla_get_pages_by_courses",
		                "moodlewsrestformat"	=> "json",
		                "courseid"			=> $this->course->remoteid,
		                "pageid"			=> $module->module_id,
		              );
		
		              $pageresult = current(json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response));
		
		              $pagecontent = current($pageresult)->content;
		              $pagefooter = "";
		              $modid = $module->module_id;
		              $btntitle = $module->name;
		              $this->course->sections[$sindex]->modules[$mindex]->name = MoojlaHelper::pageModal($btntitle,$this->course->remoteid, $modid, $pageheader, $pagecontent, $pagefooter);
		            }
		            else
		            {
		              $description = $module->description;
		              $this->course->sections[$sindex]->modules[$mindex]->name = '<a href="'.$module->url.'" onclick="' . $module->onclick . '" >'.$module->name.'</a><div class="moduledescription" >'.$description.'</div>';
		            }
		
		          }
		          else if($module->modname == "customcert")
		          {
		            $cert_download = $params->get('cert_download');
		            if($cert_download == 1) {
		              $module->url .= '&downloadown=1';
		            }
		            $description = $module->description;
		            $this->course->sections[$sindex]->modules[$mindex]->name = '<a href="'.$module->url.'" onclick="' . $module->onclick . '" >'.$module->name.'</a><div class="moduledescription" >'.$description.'</div>';
		          }
		          else if($module->modname == "resource")
		          {
		            $rmod = current($module->module_idContents_module_idContentD);
		            $mimetype = substr($rmod->mimetype, 0, 5);
		            $rmod = current($module->module_idContents_module_idContentD);
		            $videotype = trim($params->get('videotype', 1));
		            $src = str_replace('/webservice/pluginfile.php/', '/auth/moojla/pluginfile_moojla.php/', $rmod->fileurl);
		            $module->module_idContents_module_idContentD[0]->fileurl = $src;
		            $options = array(
		              "src"			=>	$src,
		              "id"			=>	$module->module_id,
		              "name"		=>	$module->name,
		              "onclick"		=>	$module->onclick,
		              "mimetype"	=>	$mimetype,
		              "course"		=> $this->item
		            );
		
		
		            $this->course->sections[$sindex]->modules[$mindex]->name = MoojlaHelper::fileActionButton($options, $videotype);
		          }
		          else
		          {
		            $description = $module->description;
		            $this->course->sections[$sindex]->modules[$mindex]->name = '<a href="'.$module->url.'" onclick="' . $module->onclick . '" >'.$module->name.'</a><div class="moduledescription" >'.$description.'</div>';
		            if(is_array($moodleskyroommods) && in_array($module->modname, $moodleskyroommods))
		            {
		              $this->course->sections[$sindex]->modules[$mindex]->name = '<div class="class-online">' . $this->course->sections[$sindex]->modules[$mindex]->name . '</div>';
		            }
		          }
		        }
		
		        unset($this->course->sections[$sindex]->modules[$mindex]->module_idContents_module_idContentD);
		        if($module->module_idContents_module_idContentD)
		        {
		          foreach($module->module_idContents_module_idContentD as $cindex => $content)
		          {
		            $this->course->sections[$sindex]->modules[$mindex]->content[$cindex] = clone $content;
		          }
		        }
		        else
		        {
		          $this->course->sections[$sindex]->modules[$mindex]->content = array();
		        }
		
		      }
		    }
		    else
		    {
		      $this->course->sections[$sindex]->modules = array();
		    }
		  }
		}
		/*
		                      $this->course->sections = ($this->course->sections ? $this->course->sections : array());
		                      foreach($this->course->sections as $sindex => $section){
		                        if(!$section)
		                          $this->course->sections[$sindex] = array();
		                      }*/
		
		
		
		$teachers = $this->course->teachers;
		$teachers = trim($teachers, '"');
		
		$this->teachers = json_decode($teachers);
		JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');
		$this->teachersFromMoodle = array();
		$dataObj = array(
		  "wsfunction"			=> "moojla_user_get_users",
		  "moodlewsrestformat"	=> "json",
		  "criteria"			=> array()
		);
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__moojla_enrolment', 'e'));
		$query->join('INNER', $db->quoteName('#__users', 'u') . ' ON ' . $db->quoteName('e.jid') . ' = ' . $db->quoteName('u.id'));
		$query->join('INNER', $db->quoteName('#__moojla_user_map', 'um') . ' ON ' . $db->quoteName('e.jid') . ' = ' . $db->quoteName('um.jid'));
		$query->where($db->quoteName('e.moojlacourse') . ' =  ' . $db->quote($this->course->remoteid));
		$query->where($db->quoteName('e.role') . ' = 3 ');
		$query->where($db->quoteName('e.published') . ' = 1 ');
		$db->setQuery($query);
		$this->teachersFromMoodle = $db->loadAssocList();
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('muserfields', 'juserfields')));
		$query->from($db->quoteName('#__moojla_user_field_map'));
		$query->where($db->quoteName('iscv') . ' = 1 ');
		$query->where($db->quoteName('published') . ' = 1 ');
		$db->setQuery($query);
		$cv_field = $db->loadAssocList();
		
		if(is_array($cv_field))
		  $cv_field = current($cv_field);
		
		if($cv_field)
		{
		  foreach($this->teachersFromMoodle as $tindex => $teacher)
		  {
		    $prefix = substr($cv_field['juserfields'], 0, 2);
		    switch($prefix)
		    {
		      case 'sj':
		        $thisuser = JFactory::getUser($teacher['jid']);
		        $field = substr($cv_field['juserfields'], 3);
		        $cv = $thisuser->$field;
		        break;
		      case 'jf':
		        $db = JFactory::getDbo();
		        $query = $db->getQuery(true);
		        $query
		          ->select('fv.value')
		          ->from($db->quoteName('#__fields', 'f'))
		          ->join('INNER', $db->quoteName('#__fields_values', 'fv') . ' ON ' . $db->quoteName('f.id') . ' = ' . $db->quoteName('fv.field_id'))
		          ->where($db->quoteName('fv.item_id') . ' = ' . $db->quote($teacher['jid']));
		        $db->setQuery($query);
		        $cv = $db->loadResult();
		        break;
		      case 'cb':
		        $field = substr($cv_field['juserfields'], 3);
		        $db = JFactory::getDbo();
		        $query = $db->getQuery(true);
		        $query->select($db->quoteName($field));
		        $query->from($db->quoteName('#__comprofiler'));
		        $query->where($db->quoteName('user_id') . ' = ' . $db->quote($teacher['jid']));
		        $db->setQuery($query);
		        $cv = $db->loadResult();
		        break;
		    }
		    if(isset($cv))
		      $this->teachersFromMoodle[$tindex]['cv'] = $cv;
		  }
		}
		
		$this->course_button_lable = "";
		$this->entermethod = 2;
		if($this->enrolState)
		{
		  $this->course_button_lable = "ورود به درس";
		  $this->entermethod = 0;
		}
		elseif($this->course->guest)
		{
		  $this->course_button_lable = "ثبت نام در درس (رایگان)";
		  $this->entermethod = 1;
		}
		elseif($this->course->self_enrolment)
		{
		  $this->course_button_lable = "ثبت نام در درس";
		  $this->entermethod = 2;
		}
		elseif($this->course->cost != 0)
		{
		  $this->course_button_lable = "خرید درس";
		  $this->entermethod = 3;
		}
		else{
		  $this->course_button_lable = "بدون اجازه ی ثبت نام یا ورود";
		  $this->entermethod = 4;
		}
		$params = JComponentHelper::getParams('com_moojla');
		$loginurl = trim($params->get('loginurl'));
		$loginurl = ($loginurl != "" ? $loginurl : JRoute::_("index.php?option=com_users&task=login&tmpl=component"));
		$registrationurl = trim($params->get('registrationurl'));
		$registrationurl = ($registrationurl != "" ? $registrationurl : JRoute::_("index.php?option=com_users&view=registration&tmpl=component"));
		$modalLoginHtml =MoojlaHelper::createButton($this->course_button_lable, $this->item->id, $loginurl, $registrationurl);
		
		$this->redirect_url = "/";
		$moodle_url= trim($this->params->get('moodle_url'));
		$this->moodle_url = $moodle_url;
		$this->htmlButton = "";
		if(!$user->id)
		{
		  $this->htmlButton = $modalLoginHtml ;
		}
		else
		{
		  switch($this->entermethod)
		  {
		    case 0:
		      $this->redirect_url = $moodle_url."course/view.php?id=".$this->course->remoteid;
		      break;
		    case 1:
		      $this->redirect_url .= "index.php?option=com_moojla&task=coursedetail.enrol&itemid=" . $this->item->id;
		      break;
		    case 2:
		      $this->redirect_url .= "index.php?option=com_moojla&task=coursedetail.enrol&itemid=" . $this->item->id;
		      break;
		    case 3:
		      $db = JFactory::getDbo();
		      $query = $db->getQuery(true);
		      $query->select($db->quoteName('product_id'));
		      $query->from($db->quoteName('#__hikashop_product'));
		      $query->where($db->quoteName('product_code') . ' = ' . $db->quote($this->item->remoteid));
		      $db->setQuery($query);
		      $product_id = $db->loadResult();
		      // shop_integration
		      $shop_integration = trim($params->get('shop_integration'));
		      if($shop_integration == "0")
		      {
		        $this->redirect_url .= "index.php?option=com_moojla&view=coursedetail&id=".$this->item->id;
		        $this->app->enqueueMessage(JText::_('MOOJLA_NO_SHOP_INTEGRATION_SELECTED')); // translate need
		      }
		      else if($shop_integration == 'hk') // hikashop
		      {
		        $this->redirect_url .= "index.php?option=com_hikashop&ctrl=product&task=show&cid=" . $product_id; 
		      }
		      break;
		    case 4:
		      $this->redirect_url .= "index.php"; // todo after for course selling
		      break;
		  }
		  $this->htmlButton = "<input type='button' onclick=\"window.location.href='".JRoute::_($this->redirect_url, false)."'\" value='".$this->course_button_lable."'>";
		}
		
		$this->course->favorite=$this->get('favorite');
		$rate= $this->get('rate');
		$this->course->rate =$rate['rate'];
		$this->course->average =$rate['average'];
		$this->document->addScriptOptions('rate' ,!empty($this->course->rate)?$this->course->rate:0);
		
		$this->course->params =$this->params;
		
		if($this->item->useglobalvideo == 1)
		  $this->course->videodownload = $params->get('preventdownload', 0);
		else
		  $this->course->videodownload = $this->item->preventdownload;
		
		if($this->item->useglobalaudio == 1)
		  $this->course->audiodownload = $params->get('preventdownloadaudio', 0);
		else
		  $this->course->audiodownload = $this->item->preventdownloadaudio;
		
		
		JPluginHelper::importPlugin("content");
		JPluginHelper::importPlugin("moojlacourse");
		$this->courseEventDispacher = JEventDispatcher::getInstance();
		
		$this->course->htmlButton = $this->htmlButton;
		$this->course->teachersFromMoodle = $this->teachersFromMoodle;
		$this->course->enrolState = $this->enrolState;
		
		$course_layout = $params->get('course_detail_layout', -1);
		$layout = 'default';
		if(property_exists($this->item, 'layout') && $this->item->layout && $this->item->layout != -1)
		{
		  $layout = explode('.', $this->item->layout)[0];
		}
		else
		{
		  if($course_layout != -1)
		  {
		    $layout = explode('.', $course_layout)[0];
		  }
		}
		$this->setLayout($layout);
		/***[/JCBGUI$$$$]***/
		

		// Set the toolbar
		$this->addToolBar();

		// set the document
		$this->_prepareDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode(PHP_EOL, $errors), 500);
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_SITE.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new moojlaHeaderCheck;

		// always load these files.
		$this->document->addScript(JURI::root(true) . "/media/com_moojla/pusher/js/pusher.min.js", (MoojlaHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");

		// Add View JavaScript File
		$this->document->addScript(JURI::root(true) . "/components/com_moojla/assets/js/coursedetail.js", (MoojlaHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");
		
		/***[JCBGUI.site_view.php_document.38.$$$$]***/
		$this->document->addScriptOptions('token', JSession::getFormToken());
		$this->getModel()->updateHits($this->item->id);
		/***[/JCBGUI$$$$]***/
		 
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/components/com_moojla/assets/css/coursedetail.css', (MoojlaHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
		// Set the Custom JS script to view
		$this->document->addScriptDeclaration("
			
			/***[JCBGUI.site_view.js_document.38.$$$$]***/
			jQuery(document).ready(function($){
			  $('#regtabbtn').click(function(){
			    $('#regtabbtn').addClass('active_tab_login_registration');
			    $('#logintabbtn').removeClass('active_tab_login_registration');
			    $('#moojla-reg-modal-content').addClass('show_content');
			    $('#moojla-login-modal-content').removeClass('show_content');
			  })
			
			
			
			
			  $('#logintabbtn').click(function(){
			    $('#logintabbtn').addClass('active_tab_login_registration');
			    $('#regtabbtn').removeClass('active_tab_login_registration');
			    $('#moojla-login-modal-content').addClass('show_content');
			    $('#moojla-reg-modal-content').removeClass('show_content');
			  })  
			
			})
			
			/***[/JCBGUI$$$$]***/
			
		");
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{

		// set help url for this view if found
		$help_url = MoojlaHelper::getHelpUrl('coursedetail');
		if (MoojlaHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_MOOJLA_HELP_MANAGER', false, $help_url);
		}
		// now initiate the toolbar
		$this->toolbar = JToolbar::getInstance();
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var, $sorten = false, $length = 40)
	{
		// use the helper htmlEscape method instead.
		return MoojlaHelper::htmlEscape($var, $this->_charset, $sorten, $length);
	}
}
