<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		default_card_mahdi.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

?>

<!--[JCBGUI.template.template.18.$$$$]-->
<?php

require_once JPATH_SITE.'/components/com_moojla/helpers/moojla.php';
JFactory::getDocument()->addScript(JURI::root(true) . "/components/com_moojla/assets/js/course_search.js", (MoojlaHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");
JFactory::getDocument()->addStyleSheet(JURI::root(true) .'/components/com_moojla/assets/css/course_search.css', (MoojlaHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');

	if (!function_exists('escape_text'))
    {
        function escape_text($text){
            $text2= preg_replace("/<.*?>/", "", $text);
            $result = mb_substr($text2, 0, 200,'UTF-8');
            return $result.'...';
        }
    }

?>

<?php if(empty($this->courses)): ?>
    <div class="col-md-12">
        <p style="text-align: center"><?= JText::_('COM_MOOJLA_NO_COURSE_FOUND');?></p>
    </div>
<?php endif; ?>

<?php foreach($this->courses as $course): ?>

    <div class="col-md-4 pl-1 pr-1 mb-2 min-w">
		<div class="lmskaran--course-search-card">
		
			<div class="sliding-card">
				<div class="element-center">
					<?php if(!$course->summary == null):?>
					<h3 class="description-course-title">درباره درس :</h3>
					<div class="description-course"><?php echo escape_text($course->summary); ?></div>
					<?php else:?>
					<h3 class="description-course-title">درباره درس :</h3>
					<div class="description-course"><span>این درس توضیحات ندارد</span></div>
					<?php endif;?>
				</div>
			</div>
			
			<div class="sliding-card-rating">
					<?php
						$this->table->load($course->id);
						$this->dispatcher->trigger('onAfterCourseSearchCard', array('com_moojla.course_search', $this->table, $course));
					?>
			</div>
		
			<div class="head-lmskaran--course-search-card">
			<div class="pack-buttons">
				<div class="button-show-sliding">
					<div class="bars-top"></div>
					<div class="bars-center"></div>
					<div class="bars-bottom"></div>
				</div>
				<div class="button-show-item-rating">امتیاز دهی</div>
			</div>
			<?php echo JLayoutHelper::render('favorite', ['course'=>$course]); ?>
			</div>
			<div class="image-lmskaran--course-search-card">
				<div class="round-image-lmskaran--course-search-card">
					<a href="<?= JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$course->remoteid); ?>">
						<?php if(!$course->summary_files == null):?>
							<img style="width: 100%" src="<?= $course->summary_files; ?>" alt="">
						<?php else:?>
							<img style="width: 100%" src="/components/com_moojla/views/course_search/assets/images/no-image.jpg" alt="">
						<?php endif;?>
					</a>
				</div>
			</div>
			<div class="main-lmskaran--course-search-card">
				<div class="main-lmskaran--course-search-card-content">
					<h3>                
						<a href="<?= JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$course->remoteid); ?>"><?= $course->shortname; ?>
						</a>
					</h3>
					<?php
						$a=JRoute::_('index.php?option=com_moojla&view=courses&cid='.$course->catid.'&id='.$course->catid);
					?>
					<a href="<?= $a; ?>">
					
						<span class="cat-name"><?= $course->cat_name; ?></span>
					</a>
                  <ul>
                    <?php $fields = FieldsHelper::getFields('com_moojla.course', $course, true); ?>
                    <?php foreach($fields as $field):

                        $custom_field= FieldsHelper::render($field->context, 'field.render', array('field' => $field));
                    ?>
                    <?php if($field->params->get('display') != 0): ?>
                        <?php if($custom_field): ?>
                            <li style="padding: 10px 0;" class="list-group-item">
                                <?= $custom_field; ?>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php endforeach; ?>
                    </ul>
					<?php if($this->items['cs_display_cost']): ?>
                        <div class="costCourse"><span style="color:#9e9e9e;"> هزینه :&nbsp </span><span class="font-size-cost"><?= $course->cost; ?></span></div>
					<?php endif; ?>				</div>
				<div class="button-course">
					<a href="<?= JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$course->remoteid); ?>">
					<span class="button-GoToCourse">رفتن به درس</span>
					</a>
				</div>
			</div>
		</div>
    </div>
<?php endforeach; ?>
<!--[/JCBGUI$$$$]-->

