<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		courses.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Moojla Model for Courses
 */
class MoojlaModelCourses extends JModelList
{
	/**
	 * Model user data.
	 *
	 * @var        strings
	 */
	protected $user;
	protected $userId;
	protected $guest;
	protected $groups;
	protected $levels;
	protected $app;
	protected $input;
	protected $uikitComp;

	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return      string  An SQL query
	 */
	protected function getListQuery()
	{
		// Get the current user for authorisation checks
		$this->user = JFactory::getUser();
		$this->userId = $this->user->get('id');
		$this->guest = $this->user->get('guest');
		$this->groups = $this->user->get('groups');
		$this->authorisedGroups = $this->user->getAuthorisedGroups();
		$this->levels = $this->user->getAuthorisedViewLevels();
		$this->app = JFactory::getApplication();
		$this->input = $this->app->input;
		$this->initSet = true; 
		// Make sure all records load, since no pagination allowed.
		$this->setState('list.limit', 0);
		// Get a db connection.
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);

		// Get from #__moojla_course as a
		$query->select($db->quoteName(
			array('a.id','a.cat_id','a.cat_name','a.catid','a.currency','a.startdate','a.summary_files','a.teachers','a.cost','a.remoteid','a.guest','a.in_enrol_date','a.enddate','a.summary','a.shortname','a.fullname'),
			array('id','cat_id','cat_name','catid','currency','startdate','summary_files','teachers','cost','remoteid','guest','in_enrol_date','enddate','summary','shortname','fullname')));
		$query->from($db->quoteName('#__moojla_course', 'a'));

		// Get from #__moojla_category_map as b
		$query->select($db->quoteName(
			array('b.id','b.jcatid','b.mcatid'),
			array('category_map_id','category_map_jcatid','category_map_mcatid')));
		$query->join('INNER', ($db->quoteName('#__moojla_category_map', 'b')) . ' ON (' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('b.jcatid') . ')');
		// Check if JFactory::getApplication()->input->get('cid') is a string or numeric value.
		$checkValue = JFactory::getApplication()->input->get('cid');
		if (isset($checkValue) && MoojlaHelper::checkString($checkValue))
		{
			$query->where('b.mcatid = ' . $db->quote($checkValue));
		}
		elseif (is_numeric($checkValue))
		{
			$query->where('b.mcatid = ' . $checkValue);
		}
		// Get where a.published is 1
		$query->where('a.published = 1');

		// return the query object
		return $query;
	}

	/**
	 * Method to get an array of data items.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$user = JFactory::getUser();
		// load parent items
		$items = parent::getItems();

		// Get the global params
		$globalParams = JComponentHelper::getParams('com_moojla', true);

		// Insure all item fields are adapted where needed.
		if (MoojlaHelper::checkArray($items))
		{
			// Load the JEvent Dispatcher
			JPluginHelper::importPlugin('content');
			$this->_dispatcher = JEventDispatcher::getInstance();
			foreach ($items as $nr => &$item)
			{
				// Always create a slug for sef URL's
				$item->slug = (isset($item->alias) && isset($item->id)) ? $item->id.':'.$item->alias : $item->id;
				// Check if item has params, or pass whole item.
				$params = (isset($item->params) && MoojlaHelper::checkJson($item->params)) ? json_decode($item->params) : $item;
				// Make sure the content prepare plugins fire on teachers
				$_teachers = new stdClass();
				$_teachers->text =& $item->teachers; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (teachers) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_moojla.courses.teachers', &$_teachers, &$params, 0));
				// Make sure the content prepare plugins fire on summary_files
				$_summary_files = new stdClass();
				$_summary_files->text =& $item->summary_files; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (summary_files) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_moojla.courses.summary_files', &$_summary_files, &$params, 0));
				// Make sure the content prepare plugins fire on summary
				$_summary = new stdClass();
				$_summary->text =& $item->summary; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (summary) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_moojla.courses.summary', &$_summary, &$params, 0));
			}
		}

		// return items
		return $items;
	}
}
