<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');



jimport('joomla.application.component.model');

class InvoicesModelPayment extends JModelLegacy
{
	  
	function __construct()
	{
		parent::__construct();

		$id = JRequest::getVar('id');
		$this->setId((int)$id);
				
	}


	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
		
	}
	
	function &getData()
	{
		
		// Load the data
		
		$query = 	' SELECT pa.*, i.*, pa.id AS id, u.username, u.name AS theusername '.
					' FROM #__invoices_payments AS pa '.
					' LEFT JOIN #__invoices_invoices AS i ON i.id = pa.invoice_id '.
					' LEFT JOIN #__invoices_contacts AS co ON co.id = i.user_id '.
					' LEFT JOIN #__users AS u ON u.id = co.user_id '.
					' WHERE pa.id = ' . $this->_id
					;
		$this->_db->setQuery( $query );
		$this->_data = $this->_db->loadObject();
		
		//$this->_data->taxes = explode(",", $this->_data->taxes );

		return $this->_data;
	}
	
	function sendMail(){
		$data = $this->getData();
		
		$params = JComponentHelper::getParams( 'com_invoices' );
		
		$from = $params->get('email_email') ;
		$from_name = $params->get('email_name') ;
		$subject = $params->get('email_subject_payment') ;

		$view		= $this->getPaymentView();
		
		$view->payment		= $this->getData();
		$view->params		= $params;
		
		$view->_path['template'][1] = JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'payment'.DS.'tmpl' ;
		
		$plantilla = 'email' ;
		
		//email to the admin
		$view->payment->towho = "admin" ;
		$message = $view->loadTemplate( $plantilla );
		$to = $from;
		
		jimport('joomla.mail.mail');
		$mail = JFactory::getMailer();
		$mail->setsender(array($from, $from_name));
		$mail->addRecipient($to);
		$mail->setSubject($subject);
		$mail->setbody($message);
		$mail->isHTML(true);
		
		$success = $mail->Send();
		
		//email to the user
		$view->payment->towho = "user" ;
		$message = $view->loadTemplate( $plantilla );
		$to = $view->payment->to_email;

		$toBlock = str_replace(" ", "", $to); //Delete spaces between emails
		$toMails = explode(",", $toBlock);
		
		$mail = JFactory::getMailer();
		$mail->setsender(array($from, $from_name));
		$mail->addRecipient($toMails);
		$mail->setSubject($subject);
		$mail->setbody($message);
		$mail->isHTML(true);

		$success2 = $mail->Send();
		
		if($success && $success2) return true;
		else return false;
	
	}
	
	function getPaymentView()
	{
		if (!class_exists( 'InvoicesViewPayment' ))
		{
			// Build the path to the model based upon a supplied base path
			$path = JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'payment'.DS.'view.html.php';
			$false = false;

			// If the model file exists include it and try to instantiate the object
			if (file_exists( $path )) {
				require_once( $path );
				if (!class_exists( 'InvoicesViewPayment' )) {
					JError::raiseWarning( 0, 'View class InvoicesViewPayment not found in file.' );
					return $false;
				}
			} else {
				JError::raiseWarning( 0, 'View InvoicesViewPayment not supported. File not found.' );
				return $false;
			}
		}

		$view = new InvoicesViewPayment();
		return $view;
	}
	
	
}