<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
$config              = HelpdeskproHelper::getConfig();
?>
<table class="admintable <?php echo $bootstrapHelper->getClassMapping('table table-striped table-bordered'); ?> table-condensed">
	<tr>
		<th colspan="2"><?php echo Text::_('HPD_TICKET_DETAIL'); ?></th>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_TICKET_ID'); ?>
		</td>
		<td>
			<?php echo $item->id; ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_CATEGORY'); ?>
		</td>
		<td>
			<?php echo $item->category_title ; ?>
		</td>
	</tr>
	<?php
	if ($item->user_id > 0)
	{
	?>
		<tr>
			<td>
				<?php echo Text::_('HDP_USER'); ?>
			</td>
			<td>
				<?php echo $item->username; ?>[<?php echo $item->user_id; ?>]
			</td>
		</tr>
	<?php
	}
	?>
	<tr>
		<td>
			<?php echo Text::_('HDP_NAME'); ?>
		</td>
		<td>
			<?php echo $item->name; ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_EMAIl'); ?>
		</td>
		<td>
			<a href="mailto:<?php echo $item->email; ?>"><?php echo $item->email; ?></a>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_TICKET_STATUS'); ?>
		</td>
		<td>
			<?php echo $item->status ; ?>
		</td>
	</tr>
	<?php
	if ($config->get('enable_rating', 1) && $item->rating)
	{
		switch ($item->rating)
		{
			case 1:
				$img = 'unsatisfactory.png';
				$title = Text::_('HDP_VERY_POOR');
				break ;
			case 2:
				$img = 'poor.png';
				$title = Text::_('HDP_FAIR');
				break ;
			case 3:
				$img = 'average.png';
				$title = Text::_('HDP_AVERAGE');
				break ;
			case 4:
				$img = 'good.png';
				$title = Text::_('HDP_GOOD');
				break ;
			case 5:
				$img = 'great.png';
				$title = Text::_('HDP_EXCELLENT');
				break ;
		}
		?>
			<tr>
				<td>
					<?php echo Text::_('HDP_RATING'); ?>
				</td>
				<td>
					<img src="<?php echo $rootUri . '/media/com_helpdeskpro/feedback/' . $img; ?>" title="<?php echo $title; ?>" />
				</td>
			</tr>
		<?php
	}
	?>
	<tr>
		<td>
			<?php echo Text::_('HDP_TICKET_PRIORITY'); ?>
		</td>
		<td>
			<?php echo $item->priority ; ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_CREATED_DATE'); ?>
		</td>
		<td>
			<?php echo HTMLHelper::_('date', $item->created_date, $config->date_format); ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_MODIFIED_DATE'); ?>
		</td>
		<td>
			<?php echo HTMLHelper::_('date', $item->modified_date, $config->date_format); ?>
		</td>
	</tr>
	<?php
	if (count($fields))
	{
	?>
		<tr><th colspan="2"><?php echo Text::_('HPD_EXTRA_INFORMATION'); ?></th></tr>
		<?php
		foreach($fields as $field)
		{
		    if (in_array($field->fieldtype, ['Heading', 'Message']))
            {
                continue;
		    }
		?>
			<tr>
				<td>
					<?php echo $field->title ; ?>
				</td>
				<td>
					<?php echo @$fieldValues[$field->id]; ?>
				</td>
			</tr>
		<?php
		}
	}

	if (!empty($results))
	{
		foreach($results as $result)
		{
			echo $result ;
		}
	}
	?>
</table>
