<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
$iconEdit        = $bootstrapHelper->getClassMapping('icon-edit');
$iconTrash       = $bootstrapHelper->getClassMapping('icon-trash');
$btn             = $bootstrapHelper->getClassMapping('btn');
$btnSmall        = $bootstrapHelper->getClassMapping('btn-small');

if (count($messages))
{
	$imageFileTypes = array('gif', 'jpg', 'jpeg', 'png', 'csv', 'bmp', 'txt');
	$attachmentsPath = JPATH_ROOT . '/media/com_helpdeskpro/attachments';
?>
	<tr>
		<td>
			<div class="hdp_ticket_comments">
				<ul>
					<?php
					foreach($messages as $message)
					{
					?>
						<li id="mesage-<?php echo $message->id; ?>">
							<table class="admintable <?php echo $bootstrapHelper->getClassMapping('table table-striped table-bordered'); ?> table-condensed">
								<tr>
									<td class="hdp_ticket_icon_user">
										<div class="hdp_ticket-images">
											<?php
											$avatarUrl = $rootUri . '/media/com_helpdeskpro/assets/images/icons/icon-user.jpeg';

											if ($message->user_id)
											{
												$avatar = HelpdeskproHelper::getUserAvatar($message->user_id);
												if ($avatar)
												{
													$avatarUrl = $rootUri . '/' . $avatar;
												}
											}
											?>
											<img width="60" height="60" src="<?php echo $avatarUrl; ?>" title="<?php echo $message->name; ?>">
										</div>
									</td>
									<td class="hdp_ticket_comments">
										<div class="hdp_ticket_comments_body">
											<div class="hdp_ticket_arrow"></div>
											<div class="hdp_ticket_commenter-name">
													<span class="hdp_ticket_name">
														<?php
														if ($message->user_id)
														{
															echo $message->name;
														}
														else
														{
															echo $item->name;
														}
														?>
                                                        - <a href="#<?php echo $message->id; ?>">[#<?php echo $message->id; ?>]</a>
													</span>
													<span class="hdp_ticket_date_time">
														<?php
														if ($message->user_id)
														{
															echo HTMLHelper::_('date', $message->date_added, $config->date_format);
														}
														else
														{
															echo  HTMLHelper::_('date', $message->date_added, $config->date_format);
														}
														if (HelpdeskproHelper::canUpdateComment($user, $message->id))
														{
														?>
															<button type="button" class="<?php echo $btn . ' ' . $btnSmall; ?>  edit_comment" id="<?php echo $message->id; ?>" title="<?php echo Text::_('HDP_EDIT_THIS_COMMENT'); ?>"><i class="<?php echo $iconEdit; ?>"></i></button>
														<?php
														}

														if (HelpdeskproHelper::canDeleteComment($user, $message->id))
														{
														?>
															<button type="button" class="<?php echo $btn . ' ' . $btnSmall; ?> remove_comment" id="<?php echo $message->id; ?>" title="<?php echo Text::_('HDP_DELETE_THIS_COMMENT'); ?>"><i class="<?php echo $iconTrash; ?>"></i></button>
														<?php
														}
														?>
													</span>
											</div>
											<div class="hdp_ticket_comment-text">
												<div data-title="Enter Your Comment" class="hd-edit-table" id="hdp_ticket_edit-text-<?php echo $message->id; ?>">
													<?php
													if ($config->process_bb_code)
													{
														echo HelpdeskproHelper::processBBCode($message->message);
													}
													else
													{
														if ($config->use_html_editor)
														{
															echo $message->message;
														}
														else
														{
															echo nl2br($message->message);
														}
													}
													?>
												</div>
												<?php
												if ($message->attachments)
												{
													$originalFileNames = explode('|', $message->original_filenames);
													$attachments = explode('|', $message->attachments);;
													?>
														<div class="hdp_ticket_comment-file">
															<ul>
																<?php
																	$i = 0 ;
																	foreach($originalFileNames as $fileName)
																	{
																		$actualFileName = $attachments[$i++];
																		if (!file_exists($attachmentsPath . '/' . $actualFileName))
																		{
																			continue;
																		}

																		$icon = substr($fileName, strrpos($fileName, '.') + 1);
																		$icon = strtolower($icon);
																		if (!file_exists(JPATH_SITE . "/media/com_helpdeskpro/assets/images/icons/$icon.png"))
																		{
																			$icon = "default";
																		}
																		if (in_array($icon, $imageFileTypes))
																		{
																		?>
																			<li><a class="hdp-modal" href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename='.$actualFileName.'&original_filename='.$fileName); ?>"><img height="16" width="16" src="<?php echo $rootUri . "/media/com_helpdeskpro/assets/images/icons/$icon.png" ?>" ><?php echo $fileName ?></a></li>
																		<?php
																		}
																		else
																		{
																		?>
																			<li><a href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename='.$actualFileName.'&original_filename='.$fileName); ?>"><img height="16" width="16" src="<?php echo $rootUri . "/media/com_helpdeskpro/assets/images/icons/$icon.png" ?>" ><?php echo $fileName ?></a></li>
																		<?php
																		}
																	}
																?>
															</ul>
														</div>
													<?php
												}
												?>
											</div>
										</div>
									</td>
								</tr>
							</table>
						</li>
					<?php
					}
					?>
				</ul>
			</div>
		</td>
	</tr>
	<?php
}