<?php
/**
 * @package	RSMembership!
 * @copyright	(c) 2009 - 2016 RSJoomla!
 * @link		https://www.rsjoomla.com
 * @license	GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');


// Add the javascript text variables
if (!empty($this->membershipterms)) {
	JText::script('COM_RSMEMBERSHIP_PLEASE_AGREE_MEMBERSHIP');
}
if ($this->choose_username && !$this->logged) {
	JText::script('COM_RSMEMBERSHIP_PLEASE_TYPE_USERNAME');
	JText::script('COM_RSMEMBERSHIP_USERNAME_IS_OK');
	JText::script('COM_RSMEMBERSHIP_USERNAME_NOT_OK');
}
if ($this->choose_password && !$this->logged) {
	JText::script('COM_RSMEMBERSHIP_PLEASE_TYPE_PASSWORD');
	JText::script('COM_RSMEMBERSHIP_PLEASE_TYPE_PASSWORD_6');
	JText::script('COM_RSMEMBERSHIP_PLEASE_CONFIRM_PASSWORD');
}
if (!$this->logged) {
	JText::script('COM_RSMEMBERSHIP_PLEASE_TYPE_NAME');
	JText::script('COM_RSMEMBERSHIP_PLEASE_TYPE_EMAIL');
}

JText::script('COM_RSMEMBERSHIP_THERE_WAS_AN_ERROR');

?>

<div id="rsm_subscribe" class="item-page">
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->membership->name); ?></h1>
		</div>
	<?php } ?>

<?php if (!$this->logged && $this->show_login) { ?>
	<div class="rsm_form_container">
		<?php echo $this->loadTemplate('login'); ?>
	</div>
<?php } ?>
	<div class="rsm_form_container">
	<?php if (!$this->logged) { ?>
		<h1><?php echo JText::_('COM_RSMEMBERSHIP_NEW_CUSTOMER'); ?></h1>
	<?php } ?>
	<?php if (!$this->logged && $this->show_login) { ?>
		<p><?php echo JText::_('COM_RSMEMBERSHIP_SUBSCRIBE_PLEASE_ELSE'); ?></p>
	<?php } ?>
		<form method="post" class="rsmembership_form" action="<?php echo JRoute::_('index.php?option=com_rsmembership&task=validatesubscribe'); ?>" name="membershipForm" onsubmit="return RSMembership.subscribe.validate_subscribe(this);" id="rsm_subscribe_default_form">
			<div class="item-page">
				<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_ACCOUNT_INFORMATION'); ?></h3>
				<?php if ($this->choose_username) { ?>
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label for="rsm_username"><?php echo JText::_('COM_RSMEMBERSHIP_USERNAME'); ?><?php echo (!$this->logged ? ' '.JText::_('COM_RSMEMBERSHIP_REQUIRED') : '');?>:</label></div>
					<?php if (!$this->logged) { ?>
					<div class="rsmemgrid-col-sm-8">
						<input type="text" name="username" id="rsm_username" size="40" value="<?php echo !empty($this->data->username) ? $this->escape($this->data->username) : ''; ?>" onkeyup="return RSMembership.subscribe.check_username(this)" onkeydown="RSMembership.subscribe.ajax_flag()" autocomplete="off" class="rsmemgrid-form-control rsmemgrid-form-control-sm" maxlength="50" /><?php echo JHtml::image('com_rsmembership/load.gif', 'Loading', 'id="rsm_loading" style="display: none;"', true); ?>
						<div class="clearfix"></div>
						<div id="rsm_username_message" style="display: none"></div>
						<div class="clearfix"></div>
						<div id="rsm_suggestions" style="display: none">
							<p><strong><?php echo JText::_('COM_RSMEMBERSHIP_HERE_ARE_SOME_USERNAME_SUGGESTIONS'); ?></strong><br /><a href="javascript: void(0);" onclick="rsm_check_username(document.getElementById('rsm_username'))"><strong><?php echo JText::_('COM_RSMEMBERSHIP_CHECK_OTHER_SUGGESTIONS'); ?></strong></a></p>
							<ol id="rsm_suggestions_ol"></ol>
						</div>
					</div>
					<?php } else { ?>
					<div class="rsmemgrid-col-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('username')); ?></div></div>
					<?php } ?>
				</div>
				<?php } ?>
				<?php if ($this->choose_password) { ?>
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label for="rsm_password"><?php echo JText::_('COM_RSMEMBERSHIP_PASSWORD'); ?><?php echo (!$this->logged ? ' '.JText::_('COM_RSMEMBERSHIP_REQUIRED') : '');?>:</label></div>
					<?php if (!$this->logged) { ?>
					<div class="rsmemgrid-col-sm-8"><input class="rsmemgrid-form-control rsmemgrid-form-control-sm" type="password" name="password" id="rsm_password" size="40" value="" autocomplete="off" /></div>
					<?php } else { ?>
					<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext">**********</div></div>
					<?php } ?>
				</div>
				<?php if (!$this->logged) { ?>
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label for="rsm_password2"><?php echo JText::_('COM_RSMEMBERSHIP_CONFIRM_PASSWORD'); ?> <?php echo JText::_('COM_RSMEMBERSHIP_REQUIRED'); ?>:</label></div>
					<div class="rsmemgrid-col-sm-8"><input class="rsmemgrid-form-control rsmemgrid-form-control-sm" type="password" name="password2" id="rsm_password2" size="40" value="" autocomplete="off" /></div>
				</div>
				<?php } ?>
				<?php } ?>
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label for="name"><?php echo JText::_('COM_RSMEMBERSHIP_NAME'); ?><?php echo (!$this->logged ? ' '.JText::_('COM_RSMEMBERSHIP_REQUIRED') : '');?>:</label></div>
					<?php if (!$this->logged) { ?>
					<div class="rsmemgrid-col-sm-8"><input class="rsmemgrid-form-control rsmemgrid-form-control-sm" type="text" name="name" id="name" size="40" value="<?php echo !empty($this->data->name) ? $this->escape($this->data->name) : ''; ?>" maxlength="50" autocomplete="off" /></div>
					<?php } else { ?>
					<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('name')); ?></div></div>
					<?php } ?>
				</div>
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label for="email"><?php echo JText::_( 'COM_RSMEMBERSHIP_EMAIL' ); ?><?php echo (!$this->logged ? ' '.JText::_('COM_RSMEMBERSHIP_REQUIRED') : '');?>:</label></div>
					<?php if (!$this->logged) { ?>
					<div class="rsmemgrid-col-sm-8"><input class="rsmemgrid-form-control rsmemgrid-form-control-sm" type="text" id="email" name="email" size="40" value="<?php echo !empty($this->data->email) ? $this->escape($this->data->email) : ''; ?>" maxlength="100" autocomplete="off" /></div>
					<?php } else { ?>
					<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('email')); ?></div></div>
					<?php } ?>
				</div>
			</div>
			
		<?php if (count($this->fields)) { ?>
			<div class="item-page">
				<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_OTHER_INFORMATION'); ?></h3>
				<?php foreach ($this->fields as $field) {
				$hidden = (isset($field[2]) && $field[2] == 'hidden') ? true : false;
				?>
				<div class="rsmemgrid-form-group rsmemgrid-row"<?php echo ($hidden ? ' style="display:none"':'')?>>
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
					<div class="rsmemgrid-col-sm-8"><?php echo $field[1]; ?></div>
				</div>
				<?php } ?>
			</div>
		<?php } ?>
		
		<?php if (count($this->membership_fields)) { ?>
			<div class="item-page">
				<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_INFORMATION'); ?></h3>
				<?php foreach ($this->membership_fields as $field) {
				$hidden = (isset($field[2]) && $field[2] == 'hidden') ? true : false;
				?>
				<div class="rsmemgrid-form-group rsmemgrid-row"<?php echo ($hidden ? ' style="display:none"':'')?>>
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
					<div class="rsmemgrid-col-sm-8"><?php echo $field[1]; ?></div>
				</div>
				<?php } ?>
			</div>
		<?php } ?>

		<?php if ($this->use_captcha) { ?>
		<div class="item-page">
		<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_SECURITY'); ?></h3>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<?php if ($this->use_recaptcha_new) { ?>
					<div class="rsmemgrid-col-12">
						<div class="g-recaptcha"
							data-sitekey="<?php echo $this->escape($this->config->recaptcha_new_site_key); ?>"
							data-theme="<?php echo $this->escape($this->config->recaptcha_new_theme); ?>"
							data-type="<?php echo $this->escape($this->config->recaptcha_new_type); ?>"
						></div>
					</div>
				<?php } else { ?>
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label">
					<label for="submit_captcha"><span class="hasRsmemTooltip" data-tooltipster='{"side":"left"}' title="<?php echo JText::_('COM_RSMEMBERSHIP_CAPTCHA_DESC'); ?>"><?php echo JText::_($this->captcha_case_sensitive ? 'COM_RSMEMBERSHIP_CAPTCHA_CASE_SENSITIVE' : 'COM_RSMEMBERSHIP_CAPTCHA'); ?></span></label>
				</div>
				<div class="rsmemgrid-col-sm-8">
					<?php if ($this->use_builtin) { ?>
					<img src="<?php echo JRoute::_('index.php?option=com_rsmembership&task=captcha&sid='.uniqid('captcha')); ?>" id="submit_captcha_image" alt="Antispam" />
					<span class="hasRsmemTooltip" data-tooltipster='{"side":"left"}' title="<?php echo JText::_('COM_RSMEMBERSHIP_REFRESH_CAPTCHA_DESC'); ?>"><a style="border-style: none" href="javascript: void(0)" onclick="return RSMembership.subscribe.refresh_captcha();"><?php echo JHtml::image('com_rsmembership/refresh.gif', JText::_('COM_RSMEMBERSHIP_REFRESH_CAPTCHA'), 'border="0" onclick="this.blur()" align="top"', true); ?></a></span><br />
					<input type="text" name="captcha" id="submit_captcha" size="40" value="" class="rsmemgrid-form-control rsmemgrid-form-control-sm" />
					<?php } elseif ($this->use_recaptcha) { ?>
						<?php echo $this->show_recaptcha; ?>
					<?php } ?>
				</div>
				<?php } ?>
			</div>
		</div>
		<?php } ?>

		<?php echo $this->extrasview; ?>
		
		<?php if ($this->has_coupons) { ?>
		<div class="item-page">
			<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_DISCOUNTS'); ?></h3>
			<p><?php echo JText::_('COM_RSMEMBERSHIP_COUPON_DESC'); ?></p>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label for="coupon"><?php echo JText::_('COM_RSMEMBERSHIP_COUPON'); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8">
					<?php if ($this->one_page_checkout) { ?>
						<input type="text" name="coupon" class="rsmemgrid-form-control rsmemgrid-form-control-sm" id="coupon" oninput="RSMembership.buildTotal.set_coupon(this.value,<?php echo $this->membership->id; ?>)" size="40" value="" maxlength="64" />
						<?php echo JHtml::image('com_rsmembership/load.gif', 'Loading', 'id="rsm_coupon_loading" style="display: none;"', true); ?>
						<span id="rsm-coupon-ok" ></span> <button type="button" class="btn btn-danger btn-small rsmemgrid-btn rsmemgrid-btn-sm" style="display:none" id="rsm-coupon-clear" onclick="RSMembership.buildTotal.clear_coupon(true)"><?php echo JText::_('COM_RSMEMBERSHIP_REMOVE_COUPON'); ?></button>
					<?php } else { ?>
						<input type="text" name="coupon" class="rsmemgrid-form-control rsmemgrid-form-control-sm" id="coupon" size="40" value="" maxlength="64" />
					<?php } ?>
				</div>
			</div>
		</div>
		<?php } ?>

		<?php if ($this->one_page_checkout) { ?>
			<div class="item-page" id="rsm_discount_value_container" style="display:none">
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><strong><?php echo JText::_('COM_RSMEMBERSHIP_DISCOUNT_VALUE'); ?></strong>:</label></div>
					<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><span id="rsm_discount_value" ></span></div></div>
				</div>
			</div>
		<?php } ?>

		<?php if ($this->one_page_checkout && ($this->showPayments || $this->membership->extras)) { ?>
			<?php echo $this->loadTemplate('payment'); ?>
		<?php } ?>

		<?php if (!empty($this->membershipterms)) { ?>
		<div class="item-page">
			<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_TERM'); ?></h3>
			<div id="rsm_terms_frame">
				<div class="item-page">
					<div id="rsm_terms_container">
						<h1><?php echo $this->escape($this->membershipterms->name); ?></h1>
						<?php
						if (RSMembershipHelper::getConfig('trigger_content_plugins')) {
							$this->membershipterms->description = JHtml::_('content.prepare', $this->membershipterms->description);
						}
						echo $this->membershipterms->description;
						?>
					</div> <!-- rsm_terms_container -->
				</div>
			</div>
			<div class="rsmemgrid-form-group rsmemgrid-form-check rsmemgrid-mt-2">
				<input type="checkbox" id="rsm_checkbox_agree" class="rsmemgrid-form-check-input" name="i_agree_to_terms" value="1" />
				<label for="rsm_checkbox_agree" class="rsmemgrid-form-check-label"><?php echo JText::_('COM_RSMEMBERSHIP_I_AGREE'); ?> (<?php echo $this->escape($this->membershipterms->name); ?>)</label>
			</div>
		</div>
		<?php } ?>

		<div class="form-actions">
			<button type="submit" class="btn btn-success rsmemgrid-btn rsmemgrid-float-right"><?php echo $this->one_page_checkout ? JText::_('COM_RSMEMBERSHIP_SUBSCRIBE') : JText::_('COM_RSMEMBERSHIP_NEXT'); ?></button>
		</div>
		<?php echo JHtml::_('form.token');?>
		<input type="hidden" name="option" value="com_rsmembership" />
		<input type="hidden" name="view" value="subscribe" />
		<input type="hidden" name="task" value="validatesubscribe" />
		<input type="hidden" name="cid" value="<?php echo $this->membership->id; ?>" />
		</form>
	</div>
</div>

<?php
	echo RSMembershipHelper::renderMagnificPopup('rsmembershipModal', array(
		'url' 	   => false,
		'height'   => 400
	));
?>