<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		view.html.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Reservation View class for the Login
 */
class ReservationViewLogin extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{		
		// get combined params of both component and menu
		$this->app = JFactory::getApplication();
		$this->params = $this->app->getParams();
		$this->menu = $this->app->getMenu()->getActive();
		// get the user object
		$this->user = JFactory::getUser();
		// Initialise variables.
		$this->items = $this->get('Items');
		
		/***[JCBGUI.site_view.php_jview_display.43.$$$$]***/
		$this->loginProccess();
		$this->info= $this->app->getUserState('info',array());/***[/JCBGUI$$$$]***/
		

		// Set the toolbar
		$this->addToolBar();

		// set the document
		$this->_prepareDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode(PHP_EOL, $errors), 500);
		}

		parent::display($tpl);
	}


/***[JCBGUI.site_view.php_jview.43.$$$$]***/
public function __construct($config = array())
    {
        $layout= JFactory::getApplication()->input->get('layout','default','string');
        $config['layout']= $layout;
        $this->document= JFactory::getDocument();
        parent::__construct($config);
    }

public function loginProccess()
    {
        if (!JFactory::getUser()->guest)
        {
          $this->app->enqueueMessage('برای ثبت نام ابتدا از حساب کاربری فعلی خود خارج شوید','warning');
          $this->app->redirect(JUri::root());
        }
        JFactory::getDocument()->addScriptOptions('expire', $this->app->getUserState('expire'));
        $layout= $this->getLayout();
        $info= $this->app->getUserState('info');

        if ($layout== 'default')
        {
            $this->app->setUserState('expire','' );
            $this->app->setUserState('owner.data', null);
            if (!JFactory::getUser()->guest)
                $this->app->redirect(JUri::root());
        }
        elseif ($layout== 'default_register')
        {

            if (!$info['phonenumber'] || !$info['validate'] || $info['userExist'] || !JFactory::getUser()->guest)
            {
                $this->app->redirect(JRoute::_('index.php?option=com_reservation&view=login',false));
//                $this->setLayout('default');
            }
        }
 	    elseif ($layout== 'default_password')
        {
            if (!$info['phonenumber'] || !$info['validate'] || !$info['userExist'] || !JFactory::getUser()->guest)
            {
                $this->app->redirect(JRoute::_('index.php?option=com_reservation&view=login',false));
//                $this->setLayout('default');
            }
        }
	}/***[/JCBGUI$$$$]***/


	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_SITE.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new reservationHeaderCheck;

		// Add View JavaScript File
		$this->document->addScript(JURI::root(true) . "/components/com_reservation/assets/js/login.js", (ReservationHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/components/com_reservation/assets/css/login.css', (ReservationHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		
		// set help url for this view if found
		$help_url = ReservationHelper::getHelpUrl('login');
		if (ReservationHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_RESERVATION_HELP_MANAGER', false, $help_url);
		}
		// now initiate the toolbar
		$this->toolbar = JToolbar::getInstance();
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var, $sorten = false, $length = 40)
	{
		// use the helper htmlEscape method instead.
		return ReservationHelper::htmlEscape($var, $this->_charset, $sorten, $length);
	}
}
