<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		route.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Reservation Route Helper
 **/
abstract class ReservationHelperRoute
{
	protected static $lookup;

	/**
	 * @param int The route of the Messages
	 */
	public static function getMessagesRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'messages'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=messages&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'messages'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=messages';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.messages');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Consultantitem
	 */
	public static function getConsultantitemRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'consultantitem'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=consultantitem&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'consultantitem'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=consultantitem';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.consultantitem');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Usersign
	 */
	public static function getUsersignRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'usersign'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=usersign&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'usersign'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=usersign';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.usersign');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Payment
	 */
	public static function getPaymentRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'payment'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=payment&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'payment'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=payment';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.payment');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Firstqst
	 */
	public static function getFirstqstRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'firstqst'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=firstqst&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'firstqst'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=firstqst';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.firstqst');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Consultantsignup
	 */
	public static function getConsultantsignupRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'consultantsignup'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=consultantsignup&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'consultantsignup'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=consultantsignup';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.consultantsignup');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Comment
	 */
	public static function getCommentRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'comment'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=comment&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'comment'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=comment';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.comment');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Doctors
	 */
	public static function getDoctorsRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'doctors'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=doctors&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'doctors'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=doctors';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.doctors');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Doctorsignup
	 */
	public static function getDoctorsignupRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'doctorsignup'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=doctorsignup&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'doctorsignup'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=doctorsignup';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.doctorsignup');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Doctor
	 */
	public static function getDoctorRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'doctor'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=doctor&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'doctor'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=doctor';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.doctor');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Reserve_appointment
	 */
	public static function getReserve_appointmentRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'reserve_appointment'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=reserve_appointment&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'reserve_appointment'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=reserve_appointment';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.reserve_appointment');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Consultant_plan
	 */
	public static function getConsultant_planRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'consultant_plan'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=consultant_plan&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'consultant_plan'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=consultant_plan';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.consultant_plan');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Login
	 */
	public static function getLoginRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'login'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=login&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'login'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=login';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.login');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * @param int The route of the Res_list
	 */
	public static function getRes_listRoute($id = 0, $catid = 0)
	{
		if ($id > 0)
		{
			// Initialize the needel array.
			$needles = array(
				'res_list'  => array((int) $id)
			);
			// Create the link
			$link = 'index.php?option=com_reservation&view=res_list&id='. $id;
		}
		else
		{
			// Initialize the needel array.
			$needles = array(
				'res_list'  => array()
			);
			// Create the link but don't add the id.
			$link = 'index.php?option=com_reservation&view=res_list';
		}
		if ($catid > 1)
		{
			$categories = JCategories::getInstance('reservation.res_list');
			$category = $categories->get($catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'] = $needles['category'];
				$link .= '&catid='.$catid;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid='.$item;
		}

		return $link;
	}

	/**
	 * Get the URL route for reservation category from a category ID and language
	 *
	 * @param   mixed    $catid     The id of the items's category either an integer id or a instance of JCategoryNode
	 * @param   mixed    $language  The id of the language being used.
	 *
	 * @return  string  The link to the contact
	 *
	 * @since   1.5
	 */
	public static function getCategoryRoute_keep_for_later($catid, $language = 0)
	{
		if ($catid instanceof JCategoryNode)
		{
			$id = $catid->id;			
			$category = $catid;			 
		}
		else
		{			
			throw new Exception('First parameter must be JCategoryNode');			
		}
	
		$views = array(
			"com_reservation" => "doctor",
			"com_reservation" => "consultant");
		$view = $views[$category->extension];
       
		if ($id < 1 || !($category instanceof JCategoryNode))
		{
			$link = '';
		}
		else
		{
			//Create the link
			$link = 'index.php?option=com_reservation&view='.$view.'&category='.$category->slug;
			
			$needles = array(
					$view => array($id),
					'category' => array($id)
			);
	
			if ($language && $language != "*" && JLanguageMultilang::isEnabled())
			{
				$db		= JFactory::getDbo();
				$query	= $db->getQuery(true)
					->select('a.sef AS sef')
					->select('a.lang_code AS lang_code')
					->from('#__languages AS a');
	
				$db->setQuery($query);
				$langs = $db->loadObjectList();
				foreach ($langs as $lang)
				{
					if ($language == $lang->lang_code)
					{
						$link .= '&lang='.$lang->sef;
						$needles['language'] = $language;
					}
				}
			}
	
			if ($item = self::_findItem($needles,'category'))
			{

				$link .= '&Itemid='.$item;				
			}
			else
			{
				if ($category)
				{
					$catids = array_reverse($category->getPath());
					$needles = array(
							'category' => $catids
					);
					if ($item = self::_findItem($needles,'category'))
					{
						$link .= '&Itemid='.$item;
					}
					elseif ($item = self::_findItem(null, 'category'))
					{
						$link .= '&Itemid='.$item;
					}
				}
			}
		}
		return $link;
	}

	protected static function _findItem($needles = null,$type = null)
	{
		$app      = JFactory::getApplication();
		$menus    = $app->getMenu('site');
		$language = isset($needles['language']) ? $needles['language'] : '*';

		// Prepare the reverse lookup array.
		if (!isset(self::$lookup[$language]))
		{
			self::$lookup[$language] = array();

			$component  = JComponentHelper::getComponent('com_reservation');

			$attributes = array('component_id');
			$values     = array($component->id);

			if ($language != '*')
			{
				$attributes[] = 'language';
				$values[]     = array($needles['language'], '*');
			}

			$items = $menus->getItems($attributes, $values);

			foreach ($items as $item)
			{
				if (isset($item->query) && isset($item->query['view']))
				{
					$view = $item->query['view'];

					if (!isset(self::$lookup[$language][$view]))
					{
						self::$lookup[$language][$view] = array();
					}

					if (isset($item->query['id']))
					{
						/**
						 * Here it will become a bit tricky
						 * language != * can override existing entries
						 * language == * cannot override existing entries
						 */
						if (!isset(self::$lookup[$language][$view][$item->query['id']]) || $item->language != '*')
						{
							self::$lookup[$language][$view][$item->query['id']] = $item->id;
						}
					}
					else
					{
						self::$lookup[$language][$view][0] = $item->id;
					}
				}
			}
		}

		if ($needles)
		{
			foreach ($needles as $view => $ids)
			{
				if (isset(self::$lookup[$language][$view]))
				{
					if (ReservationHelper::checkArray($ids))
					{
						foreach ($ids as $id)
						{
							if (isset(self::$lookup[$language][$view][(int) $id]))
							{
								return self::$lookup[$language][$view][(int) $id];
							}
						}
					}
					elseif (isset(self::$lookup[$language][$view][0]))
					{
						return self::$lookup[$language][$view][0];
					}
				}
			}
		}

		if ($type)
		{
			// Check if the global menu item has been set.
			$params = JComponentHelper::getParams('com_reservation');
			if ($item = $params->get($type.'_menu', 0))
			{
				return $item;
			}
		}

		// Check if the active menuitem matches the requested language
		$active = $menus->getActive();

		if ($active
			&& $active->component == 'com_reservation'
			&& ($language == '*' || in_array($active->language, array('*', $language)) || !JLanguageMultilang::isEnabled()))
		{
			return $active->id;
		}

		// If not found, return language specific home link
		$default = $menus->getDefault($language);

		return !empty($default->id) ? $default->id : null;
	}
}
