<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user      = JFactory::getUser();
$userId    = $user->get('id');
?>

<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=dashboard'); ?>" method="post" name="adminForm" id="adminForm">
	<div id="cf" class="templates tx-flex">
		<?php if (!empty( $this->sidebar)) : ?>
		<div class="tx-sidebar">
			<?php echo $this->sidebar; ?>
		</div>
		<div class="tx-main">
		<?php else : ?>
		<div class="tx-main">
		<?php endif; ?>
			<div class="page-header">
			  <h1>Templates</h1>
			</div>
			<div class="page-content">
				<?php echo NotiflyHelper::showWarning(); ?>

				<?php foreach ($this->items as $key => $item) : ?>
				<div class="panel panel-default <?php echo ($item->state ? '' : 'panel-disabled'); ?>">
					<div class="panel-body">
						<div class="media">
							<div class="media-body">
								<h3 class="media-heading">
									<?php echo ucfirst($item->name); ?>
									
									<!-- 
									<div class="switch pull-right">
						                <label>
							                <span class="muted"><?php echo ($item->state ? 'Active' : 'Disabled'); ?></span>
							                <input onclick="window.updateTemplateStatus(this);" data-id="<?php echo $item->id; ?>" class="toggleIntegration" name="jform[state]" type="checkbox" <?php echo ($item->state ? 'checked' : ''); ?> />
							                <span class="lever"></span>
						                </label>
						             </div>
						            -->
								</h3>
								<p class="well"><?php echo $item->message; ?></p>
								<p><strong>Template ID:</strong> <span class="muted"><?php echo $item->id; ?></span></p>
								<p><strong>Template Name:</strong> <span class="muted"><?php echo $item->alias; ?></span></p>
								<p><strong>Source:</strong> <span class="muted"><?php echo ucfirst($item->source); ?></span></p>
							</div>
							<div class="media-right tx-action-btns">
								<a href="index.php?option=com_notifly&task=template.edit&id=<?php echo $item->id; ?>" class="btn btn-primary btn-block"><i class="cfi-edit"></i> Edit</a>
								<!-- 
								<a href="index.php?option=com_notifly&task=template.trash&id=<?php echo $item->id; ?>" class="btn btn-danger btn-block"><i class="cfi-trash-2"></i> Delete</a> 
								-->
							</div>
						</div>
					</div>
				</div>
				<?php endforeach; // end foreach ?>
				
				<?php echo $this->pagination->getListFooter(); ?>
				
			</div>

			<input type="hidden" name="task" value="" />
			<input type="hidden" name="dashboard" value="1" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo JHtml::_('form.token'); ?>
		</div> <!-- container -->	
	</div>
</form>