<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user      = JFactory::getUser();
$userId    = $user->get('id');
$list = array_chunk($this->items, 4);

?>

<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=dashboard'); ?>" method="post" name="adminForm" id="adminForm">
<div id="cf" class="integrations tx-flex">
	<?php if (!empty( $this->sidebar)) : ?>
	<div class="tx-sidebar">
		<?php echo $this->sidebar; ?>
	</div>
	<div class="tx-main">
	<?php else : ?>
	<div class="tx-main">
	<?php endif; ?>
		<div class="page-header">
		  <h1>Integrations</h1>
		</div>
		<div class="page-content">
			<?php echo NotiflyHelper::showWarning(); ?>
			
			<?php foreach ($list as $key => $items) { ?>
				<div class="row">
				<?php foreach ($items as $key => $item) { ?>
					<?php 
					// Load language file for use throughout the plugin
					JFactory::getLanguage()->load($item->name, JPATH_ADMINISTRATOR);
					 ?>
					<div class="col-md-3">
						<div class="panel panel-default text-center">
							<div class="panel-body">
								<img class="int-logo" src="<?php echo Juri::root() . 'plugins/notifly/'.$item->element.'/media/logo.png'; ?>" alt="<?php echo $item->element; ?>">
								<h4><?php echo JText::_(strtoupper($item->name)); ?></h4>
							</div>
							<div class="panel-footer">
								<?php if($item->enabled){ ?>
									<?php $link = 'index.php?option=com_plugins&task=plugin.edit&layout=modal&tmpl=component&extension_id=' . $item->extension_id; ?>
									<a href="#integrationEdit<?php echo $item->extension_id; ?>Modal" role="button" class="btn btn-primary btn-block" data-toggle="modal" title="<?php echo JText::_('COM_MENUS_EDIT_INTEGRATION_SETTINGS'); ?>" id="title-<?php echo $item->extension_id; ?>">
										<?php echo JText::_('COM_NOTIFLY_CONFIGURE_INTEGRATION'); ?>
									</a>
								<?php  }else{ ?>
									<?php $token = JFactory::getSession()->getFormToken(); ?>
									<?php $link = 'index.php?option=com_notifly&task=integrations.enable&'.$token.'=1&ids[]='.$item->extension_id; ?>
									<a href="<?php echo $link; ?>" class="btn btn-default btn-block">
										<?php echo JText::_('COM_NOTIFLY_CONFIGURE_INTEGRATION_ENABLE'); ?>
									</a>
								<?php } ?>
							</div>
							<?php echo JHtml::_(
								'bootstrap.renderModal',
								'integrationEdit' . $item->extension_id . 'Modal',
								array(
									'title'       => JText::_('COM_NOTIFLY_EDIT_INTEGRATION_SETTINGS'),
									'backdrop'    => 'static',
									'keyboard'    => false,
									'closeButton' => true,
									'url'         => $link,
									'bodyHeight'  => '70',
									'footer'      => '<button type="button" class="tx-btn btn btn-primary" aria-hidden="true"'
											. ' onclick="jQuery(\'#integrationEdit' . $item->extension_id . 'Modal iframe\').contents().find(\'#saveBtn\').click();">'
											. JText::_('JSAVE') . '</button>'
											// . '<button type="button" class="tx-btn btn btn-primary" aria-hidden="true"'
											// . ' onclick="jQuery(\'#integrationEdit' . $item->extension_id . 'Modal iframe\').contents().find(\'#closeBtn\').click();">'
											// . JText::_('JCANCEL') . '</button>',
								)
							); ?>

						</div>
					</div>
				<?php } ?>
				</div>
			<?php } ?>
			<div class="row">
				<div class="col-md-10 col-md-offset-1">
					<div class="request-block">
						<div class="media"> 
							<div class="media-body"> 
								<h4 class="media-heading">Need Your Extension Integration?</h4> 
								We'd love to integrate your extention out-of-the-box. All you have to let us know.
							</div> 
							<div class="media-right"> <a class="btn btn-success" href="http://suggest.themexpert.com" target="_blank"><i class="cfi-twitter"></i> Let Us Know</a> </div> 
						</div>
					</div>
				</div>
			</div>

			<?php echo $this->pagination->getListFooter(); ?>

		</div>

			<input type="hidden" name="task" value="" />
			<input type="hidden" name="dashboard" value="1" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo JHtml::_('form.token'); ?>
		</div> <!-- container -->
	</div>
</form>