<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

/**
 * Integration controller class.
 *
 * @since  1.6
 */
class NotiflyControllerIntegrations extends JControllerAdmin
{
	public function enable(){
		// Check for request forgeries
		JSession::checkToken('get') or jexit(JText::_('JINVALID_TOKEN'));

		$user   = JFactory::getUser();
		$ids    = $this->input->get('ids', array(), 'array');
		$values = array('enable' => 1, 'disable' => 0);
		$task   = $this->getTask();
		$value  = ArrayHelper::getValue($values, $task, 0, 'int');
		$message = false;
		// Access checks.
		foreach ($ids as $i => $id)
		{
			if (!$user->authorise('core.edit.state', 'com_notifly.Integrations.' . (int) $id))
			{
				// Prune items that you can't change.
				unset($ids[$i]);
				JError::raiseNotice(403, JText::_('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED'));
			}
		}

		if (empty($ids))
		{
			JError::raiseWarning(500, JText::_('JERROR_NO_ITEMS_SELECTED'));
		}
		else
		{
			// Get the model.
			/** @var NotiflyModelIntegrations $model */
			$model = $this->getModel();

			// Publish the items.
			if (!$model->enable($ids, $value))
			{
				$message = new Exception($model->getError());
			}

			if ($value == 1)
			{
				$message = JText::plural('COM_NOTIFLY_N_ITEMS_ENABLED', count($ids));
			}
			else
			{
				$message = JText::plural('COM_NOTIFLY_N_ITEMS_DISABLED', count($ids));
			}

			$this->setRedirect(JRoute::_('index.php?option=com_notifly&view=integrations', false), $message);
			
			return true;
		}
		
	}
	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  The array of possible config values. Optional.
	 *
	 * @return  JModelLegacy
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Integrations', $prefix = 'NotiflyModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}
}
