<?php
/* ======================================================
 # Login as User for Joomla! - v3.5.9 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/login-as-user
 # Support: support@web357.com
 # Last modified: Wednesday 07 December 2022, 11:05:26 AM
 ========================================================= */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import Joomla view library
jimport('joomla.application.component.view');

class LoginasuserViewOverv extends JViewLegacy
{
	function display($tpl = null) 
	{
		$form	= $this->get('Form');
		
		// Check for model errors.
		if ($errors = $this->get('Errors')) {
			throw new Exception(implode('<br />', $errors), 500);
		}

		// Get Joomla! version
		$jversion = new JVersion;
		$short_version = explode('.', $jversion->getShortVersion()); // 3.8.10
		$mini_version = $short_version[0].'.'.$short_version[1]; // 3.8

		if (version_compare($mini_version, "2.5", "<=")):
			// j25x
			// Show sidebar
			$this->sidebar = "";
		else:
			// j3X
			// Include helper submenu
			LoginasuserHelper::addSubmenu('overv');
	
			// Show sidebar
			$this->sidebar = JHtmlSidebar::render();
		endif;

		// mapping variables
		$this->form = $form;
		
		// Set the toolbar
		$this->addToolBar();

		// Display the template
		parent::display($tpl);
	}

	protected function addToolBar()
	{
		// Build title
		$title = JText::_('Login as User').': '.JText::_('Overview');
		
		// Set document title
		JFactory::getDocument()->setTitle($title);
		
		// Set ToolBar title
		JToolbarHelper::title($title, 'loginasuser icon-user');
			
	}
}