<?php
/*------------------------------------------------------------------------
# com_finances - Expense Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2015 joomlathat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');
?>

<!-- Modal -->
<div class="modal fade invoice-manager" id="detailsModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">{{ current_contact.name }}</h4>

      </div>
      <div class="modal-body">

        <contactdetails
                        :contact="current_contact"
                        >
        </contactdetails>

        <invoicepreview
                        :invoice="current_invoice"
                        >
        </invoicepreview>
      </div>
      <div class="modal-footer">

        <div class="btn-group pull-left">

          <button type="button"
                  class="btn btn-link btn_no_underline"
                  id="deletebutton_modal"
                  data-loading-text="<?php echo JText::_('DELETING_CONTACT'); ?>"
                  @click.prevent="delete_contact()">
                  <span class="dlt-item"><?php echo JText::_('DELETE_CONTACT');?></span></button>

        </div>

        <div class="btn-group pull-right">

          <button type="button"
          		class="btn btn-primary"
          		id="savebutton_modal"
          		data-loading-text="<?php echo JText::_('SAVING'); ?>"
          		@click.prevent="saveContact()"
            ><?php echo JText::_('SAVE_CONTACT'); ?>
        	</button>

        </div>

        <div class="btn-group pull-right">
          <button type="button"
                  class="btn btn-default"
                  data-dismiss="modal"><?php echo JText::_('CLOSE'); ?></button>
        </div>

        <div class="btn-group pull-right">

      	  <button class="btn btn-default"
      	  				@click.prevent="preview_prev()"
      						:disabled="!exists_prev()"
      						title="<?php echo JText::_('PREV_CONTACT');?>"
                  data-toggle="tooltip"
      	  >
      	  	<span class="glyphicon glyphicon-chevron-left"></span>
      	  </button>

      		<button class="btn btn-default"
      	  				@click.prevent="preview_next()"
      						:disabled="!exists_next()"
      						title="<?php echo JText::_('NEXT_CONTACT');?>"
                  data-toggle="tooltip"
      	  >
      	  	<span class="glyphicon glyphicon-chevron-right"></span>
      	  </button>

      	</div>

        <div  v-show="current_contact.loadingInvoices || current_contact.loadingQuotes"
              class="text-muted pull-right">

          <div class="btn btn-link btn_no_underline disabled">
            <div id="loadmoreajaxloader_invoices" class="text-muted clear_row text-center">
              <div class="mdl-spinner mdl-spinner--single-color mdl-js-spinner is-active"></div>
            </div>
            <?php echo JText::_('LOADING_DATA'); ?>
          </div>

        </div>

      </div>
    </div>
  </div>
</div>
