<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class QuotesControllerQuotes extends QuotesController
{

	function __construct()
	{
		parent::__construct();
		$this->input->set('view', 'quotes');

	}

    function export(){

        //require_once(JPATH_SITE.DS.'components'.DS.'com_finances'.DS.'models'.DS.'items.php');
        require_once(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'quotes'.DS.'view.html.php');

        //$model = new FinancesModelItems();
        $model = $this->getModel('quotes');
        $view = new QuotesViewQuotes();

        $max = 5000;
        $total = $model->getTotal();
        if($total > $max){
            $link = 'index.php?option=com_invoices';
            $msg = JText::sprintf('YOU_CANONT_EXPORT', $max, $max) ;
            $this->setRedirect($link, $msg, "warning");
        }
        else{

            // filename for download
            $filename = "export_" . date('Y_m_d') . ".csv";

            header("Content-Disposition: attachment; filename=\"$filename\"");
            header("Content-Type: text/csv");
            //header("Content-Type: application/vnd.ms-excel");

            $view->setModel($model);

            $view->pagination = $model->getPagination();
            $view->cal_start = $model->getCalstart();
            $view->cal_end = $model->getCalend();
            $view->items = $model->getData();
            $view->taxes = $model->getTaxes();
            $view->status = $model->getStatus();
            $view->status_id = $model->getStatusId();

            $content = $view->loadTemplate( 'csv' );

            echo $content;

            die;

        }

    }

}
