"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Contact = function () {
  function Contact(data) {
    _classCallCheck(this, Contact);

    this.update(data);

    this.invoices = new Array();
    this.quotes = new Array();
    this.payments = new Array();

    this.summary = {
      num_invoices: 0,
      total_invoices: [],
      total_income: [],
      pending_income: [],
      update: 0,
      taxes: taxes
    };

    this.needsSaving = false;

    this.invoicesLoaded = false;
    this.quotesLoaded = false;
    this.paymentsLoaded = false;

    this.loadingInvoices = false;
    this.loadingQuotes = false;
    this.loadingPayments = false;
  }

  _createClass(Contact, [{
    key: "update",
    value: function update(data) {

      for (var field in data) {
        this[field] = data[field];
      }

      if (this.user_id) this.vincular_cliente = 1;else this.vincular_cliente = 0;
    }
  }, {
    key: "edit",
    value: function edit() {
      edit_contact(this.id);
    }
  }, {
    key: "new",
    value: function _new() {
      new_contact(this.user_id);
    }
  }, {
    key: "preview",
    value: function preview() {
      vm.current_invoice = {};
      this.getUnloadedStuff();
      preview_contact(this.id);
    }
  }, {
    key: "getUnloadedStuff",
    value: function getUnloadedStuff() {
      if (this.id != 0) {
        if (!this.invoicesLoaded) this.getInvoices();
        if (!this.quotesLoaded) this.getQuotes();
        if (!this.paymentsLoaded) this.getPayments();
      }
    }
  }, {
    key: "getInvoices",
    value: function getInvoices() {

      var url = "index.php?option=com_invoices&controller=invoices&task=load_items&limitstart=0&limit=0" + "&contact_id=" + this.id;

      var that = this;

      jQuery.ajax({
        url: url,
        cache: false,
        dataType: 'json',
        beforeSend: function beforeSend() {
          that.loadingInvoices = true;
        },
        success: function success(result) {

          that.invoices = [];
          for (var i = 0; i < result.items.length; i++) {
            that.invoices.push(new Invoice(result.items[i]));
          }

          that.summary = result.summary;
        },
        complete: function complete() {
          that.loadingInvoices = false;
          that.invoicesLoaded = true;
        }
      });
    }
  }, {
    key: "getQuotes",
    value: function getQuotes() {

      var url = "index.php?option=com_invoices&controller=invoices&task=load_items&limitstart=0&limit=0" + "&contact_id=" + this.id + "&type=2";

      var that = this;

      jQuery.ajax({
        url: url,
        cache: false,
        dataType: 'json',
        beforeSend: function beforeSend() {
          that.loadingQuotes = true;
        },
        success: function success(result) {

          that.quotes = [];
          for (var i = 0; i < result.items.length; i++) {
            that.quotes.push(new Invoice(result.items[i]));
          }

          //that.summary = result.summary;
        },
        complete: function complete() {
          that.quotesLoaded = true;
          that.loadingQuotes = false;
        }
      });
    }
  }, {
    key: "getPayments",
    value: function getPayments() {

      var url = "index.php?option=com_invoices&controller=payments&task=load_items&limitstart=0&limit=0" + "&contact_id=" + this.id;

      var that = this;

      jQuery.ajax({
        url: url,
        cache: false,
        dataType: 'json',
        beforeSend: function beforeSend() {
          that.loadingPayments = true;
        },
        success: function success(result) {

          that.payments = [];
          for (var i = 0; i < result.items.length; i++) {
            that.payments.push(new Payment(result.items[i]));
          }

          //that.summary = result.summary;
        },
        complete: function complete() {
          that.paymentsLoaded = true;
          that.loadingPayments = false;
        }
      });
    }
  }, {
    key: "invoice_total",
    value: function invoice_total() {
      if (typeof this.summary.total_invoices[vm.currency_id] !== 'undefined') {
        return this.summary.total_invoices[vm.currency_id].total;
      }
      return 0;
    }
  }, {
    key: "total_income",
    value: function total_income() {
      if (typeof this.summary.total_income[vm.currency_id] !== 'undefined') {
        return this.summary.total_income[vm.currency_id].total;
      }
      return 0;
    }
  }, {
    key: "pending_income",
    value: function pending_income() {
      if (typeof this.summary.pending_income[vm.currency_id] !== 'undefined') {
        return this.summary.pending_income[vm.currency_id].total;
      }
      return 0;
    }
  }, {
    key: "total_tax",
    value: function total_tax(tax_id) {
      if (typeof this.summary.taxes[tax_id][vm.currency_id] !== 'undefined') {
        return this.summary.taxes[tax_id][vm.currency_id];
      }
      return 0;
    }
  }]);

  return Contact;
}(); // end Contact class

//export default Contact;