<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$config = HelpdeskproHelper::getConfig();

$allowedExtensions = $config->allowed_file_types;
$maxNumberOfFiles  = (int) $config->max_number_attachments ?: 1;

if (!$allowedExtensions)
{
	$allowedExtensions = 'doc|docx|ppt|pptx|pdf|zip|rar|bmp|gif|jpg|jepg|png|swf|zipx';
}

$allowedExtensions = explode('|', $allowedExtensions);

for ($i = 0, $n = count($allowedExtensions); $i < $n; $i++)
{
	$allowedExtensions[$i] = '.' . strtolower(trim($allowedExtensions[$i]));
}

$token    = JSession::getFormToken() . '=' . 1;
$maxFileSize = 'null';

if ($config->max_file_size > 0)
{
	switch ($config->max_filesize_type)
	{
		case 1:
			$maxFileSize = (int) ($config->max_file_size / 1024 * 1024);
            break;
		case 2:
			$maxFileSize = (int) ($config->max_file_size / 1024);
	        break;
		case 3:
			$maxFileSize = (int) $config->max_file_size;
			break;
	}
}

$document = Factory::getDocument();
$rootUri  = Uri::root(true);
$document->addScript($rootUri . '/media/com_helpdeskpro/js/ticket-upload-attachments.js');
$document->addScriptOptions('maxFiles', $maxNumberOfFiles);
$document->addScriptOptions('acceptedFiles', implode(',', $allowedExtensions));
$document->addScriptOptions('maxFilesize', $maxFileSize);

Text::script('HDP_DROP_FILES_TO_UPLOAD', true);
$document->addScriptOptions('uploadProcessUrl', Uri::base(true) . '/index.php?option=com_helpdeskpro&task=ticket.upload&' . $token);