<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Model;

use OSL\Model\Model;
use OSL\Utils\Database as DatabaseUtils;
use Ossolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;

defined('_JEXEC') or die;

class Article extends Model
{
	/**
	 * Initialize the model, add new states
	 */
	protected function initialize()
	{
		$this->state->insert('id', 'int', 0);
	}

	/**
	 *
	 */
	public function getData()
	{
		$db    = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from('#__helpdeskpro_articles')
			->where('id = ' . $this->state->id)
			->where('published = 1');

		if ($fieldSuffix = HelpdeskproHelper::getFieldSuffix())
		{
			DatabaseUtils::getMultilingualFields($query, array('title', 'text'), $fieldSuffix);
		}

		$db->setQuery($query);

		return $db->loadObject();
	}


	public function hits()
	{
		$db = $this->getDbo();

		$query = $db->getQuery(true);
		$query->update('#__helpdeskpro_articles')
			->set('hits = hits + 1')
			->where('id = ' . $this->state->id);
		$db->setQuery($query);

		$db->execute();
	}
}