<?php
/**
 * @version            3.8
 * @package            Joomla
 * @subpackage         Joom Donation
 * @author             Tuan Pham Ngoc
 * @copyright          Copyright (C) 2009 - 2019 Ossolution Team
 * @license            GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class Jquery
{
	/**
	 * validate form
	 */
	public static function validateForm()
	{
		static $loaded = false;

		if (!$loaded)
		{
			$rootUri  = Uri::root(true);
			$document = Factory::getDocument();
			$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/js/validate/css/validationEngine.jquery.css');

			// Add possible language files for jquery validation engine
			$tag   = Factory::getLanguage()->getTag();
			$tag   = substr($tag, 0, 2);
			$files = [
				"jquery.validationEngine-$tag.custom.js",
				"jquery.validationEngine-$tag.js",
				"jquery.validationEngine-en.js",
			];

			foreach ($files as $file)
			{
				if (file_exists(JPATH_ROOT . '/media/com_helpdeskpro/assets/js/validate/js/languages/' . $file))
				{
					$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/validate/js/languages/' . $file);
					break;
				}
			}

			// Add validation engine
			$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/validate/js/jquery.validationEngine.js');

			$loaded = true;
		}
	}
}