<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJiveWall/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbgroupjivewall_install()
{
	// Grab GJ params to migrate the legacy params:
	$plugin				=	new PluginTable();

	$plugin->load( array( 'element' => 'cbgroupjive' ) );

	$pluginParams		=	new Registry( $plugin->getRaw( 'params', array() ) );

	if ( ( ! $pluginParams->has( 'wall_inputlimit' ) ) || ( $pluginParams->getInt( 'wall_inputlimit' ) === null ) ) {
		return;
	}

	// Migrate wall integration parameters:
	$wall				=	new PluginTable();

	$wall->load( array( 'element' => 'cbgroupjivewall' ) );

	$wallParams			=	new Registry( $wall->getRaw( 'params', array() ) );

	if ( $wallParams->getBool( 'migrated', false ) ) {
		return;
	}

	$wallParams->set( 'groups_wall_character_limit', $pluginParams->getInt( 'wall_inputlimit' ) );
	$wallParams->set( 'groups_wall_replies', $pluginParams->getInt( 'wall_reply', 0 ) );
	$wallParams->set( 'groups_wall_replies_paging', $pluginParams->getInt( 'wall_replypaging', 0 ) );
	$wallParams->set( 'groups_wall_replies_limit', $pluginParams->getInt( 'wall_replylimit' ) );
	$wallParams->set( 'groups_wall_paging', $pluginParams->getInt( 'wall_paging', 0 ) );
	$wallParams->set( 'groups_wall_limit', $pluginParams->getInt( 'wall_limit' ) );
	$wallParams->set( 'migrated', true );

	$wall->set( 'params', $wallParams->asJson() );

	$wall->store();
}