<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Following;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable         $viewer
 * @var Following         $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $layout
 * @var bool              $following
 * @var bool              $canCreate
 */

global $_CB_framework;
?>
<?php if ( in_array( $layout, array( 'simple', 'extended' ), true ) ) { ?>
	<?php if ( $following ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'unfollow', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="followStreamLink followStreamUnfollow streamItemAction" data-cbactivity-container="stream"><span class="fa fa-feed"></span> <?php echo CBTxt::T( 'Unfollow' ); ?></a>
	<?php } else { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'follow', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="followStreamLink followStreamFollow streamItemAction" data-cbactivity-container="stream"><span class="fa fa-feed"></span> <?php echo CBTxt::T( 'Follow' ); ?></a>
	<?php } ?>
<?php } else { ?>
<span class="followStreamButtons">
	<?php if ( $following ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'unfollow', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="d-none btn btn-danger btn-sm followStreamButton followStreamUnfollow streamItemAction" data-cbactivity-container="stream"><span class="fa fa-feed"></span> <?php echo CBTxt::T( 'Unfollow' ); ?></a>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'unfollow', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="btn btn-info btn-sm followStreamButton followStreamFollowed streamItemAction active" data-cbactivity-container="stream"><span class="fa fa-feed"></span> <?php echo CBTxt::T( 'Following' ); ?></a>
	<?php } else { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'follow', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="btn btn-info btn-sm followStreamButton followStreamFollow streamItemAction" data-cbactivity-container="stream"><span class="fa fa-feed"></span> <?php echo CBTxt::T( 'Follow' ); ?></a>
	<?php } ?>
</span>
<?php } ?>