<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CBLib\Database\Table\Table;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend article activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */

global $_CB_framework;

$notification			=	( $stream instanceof NotificationsInterface );
$id						=	(int) $matches[1];
$type					=	( isset( $matches[2] ) ? $matches[2] : null );

switch ( $type ) {
	case 'comment':
		if ( $notification ) {
			$title		=	CBTxt::T( 'COMMENTED_ON_ARTICLE_TITLE', 'commented on article <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_content&view=article&mesid=' . $id, '[title]' => '#' . $id ) );
		} else {
			$title		=	CBTxt::T( 'commented on article' );
		}
		break;
	case 'like':
		if ( $notification ) {
			$title		=	CBTxt::T( 'LIKED_ARTICLE_TITLE', 'liked article <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_content&view=article&mesid=' . $id, '[title]' => '#' . $id ) );
		} else {
			$title		=	CBTxt::T( 'liked article' );
		}
		break;
	default:
		if ( $notification ) {
			$title		=	CBTxt::T( 'PUBLISHED_ARTICLE_TITLE', 'published article <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_content&view=article&mesid=' . $id, '[title]' => '#' . $id ) );
		} else {
			$title		=	CBTxt::T( 'published a new article' );
		}
		break;
}

if ( $notification ) {
	$row->set( 'link', $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_content&view=article&mesid=' . $id );
}

/** @var Table $article */
$article				=	$row->source();

if ( ( ! $article ) || ( ! $article->getInt( 'id', 0 ) ) ) {
	return;
}

if ( $notification ) {
	$row->set( 'link', cbarticlesModel::getUrl( $article, false, 'article' ) );

	$articleTitle		=	$article->getString( 'title' );

	if ( ! $articleTitle ) {
		$articleTitle	=	$article->getString( 'introtext' );
	}

	if ( cbutf8_strlen( $articleTitle ) > 50 ) {
		$articleTitle	=	trim( cbutf8_substr( $articleTitle, 0, 50 ) ) . '...';
	}

	if ( $articleTitle ) {
		switch ( $type ) {
			case 'comment':
				$title	=	CBTxt::T( 'COMMENTED_ON_ARTICLE_TITLE', 'commented on article <a href="[url]">[title]</a>', array( '[url]' => cbarticlesModel::getUrl( $article, true, 'article' ), '[title]' => $articleTitle ) );
				break;
			case 'like':
				$title	=	CBTxt::T( 'LIKED_ARTICLE_TITLE', 'liked article <a href="[url]">[title]</a>', array( '[url]' => cbarticlesModel::getUrl( $article, true, 'article' ), '[title]' => $articleTitle ) );
				break;
			default:
				$title	=	CBTxt::T( 'PUBLISHED_ARTICLE_TITLE', 'published article <a href="[url]">[title]</a>', array( '[url]' => cbarticlesModel::getUrl( $article, true, 'article' ), '[title]' => $articleTitle ) );
				break;
		}
	}
} else {
	$insert				=	'<div class="bg-light border p-2 cbArticlesActivity cbMoreLess">'
						.		'<div class="streamItemContent cbMoreLessContent">'
						.			'<div><strong><a href="' . cbarticlesModel::getUrl( $article, true, 'article' ) . '">' . $article->getString( 'title' ) . '</a></strong></div>'
						.			Application::Cms()->prepareHtmlContentPlugins( $article->getHtml( 'introtext' ) )
						.		'</div>'
						.		'<div class="fade-edge cbMoreLessOpen hidden">'
						.			'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'Read More...' ) . '</a>'
						.		'</div>'
						.	'</div>';

	if ( $type ) {
		$row->params()->set( 'overrides.tags_asset', 'article.' . $id );
		$row->params()->set( 'overrides.likes_asset', 'article.' . $id );
		$row->params()->set( 'overrides.comments_asset', 'article.' . $id );
	} else {
		$row->params()->set( 'overrides.tags_asset', 'asset' );
		$row->params()->set( 'overrides.likes_asset', 'asset' );
		$row->params()->set( 'overrides.comments_asset', 'asset' );
	}
}