<?php
/**
 * @version			2.2.0
 * @author			Nicholas G. Antimisiaris
 * @authoremail		nant@joomlapolis.com
 * @authorurl		www.joomlapolis.com
 * @package			Joomla 2 CiviCRM User Sync
 * @file			civicrmlocationlist.php
 * @copyright		Copyright (C) 2013-2019. All rights reserved
 * @license			GNU GPL version 2
 * @description		Code used by Joomla plugin parameter form to grab information from CiviCRM installation
 * 					Location types from CiviCRM are read and presented as a single-select list for admin to
 * 					specify what location type to use for email if a new contact needs to be created.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

class JFormFieldcivicrmlocationtypelist extends JFormFieldList
{
	protected $type = 'civicrmlocationtypelist';

	/**
 	* Method to get the field options.
 	*
 	* @return  array  The field option objects.
 	*
 	* @since   11.1
 	*/
	protected function getOptions()
	{
		// Initialize variables.
		$options = array();
		if (!file_exists(JPATH_ROOT . '/administrator/components/com_civicrm/helpers/api.php')) {

			// CiviCRM Joomla component not installed so just specify single option notice

			$j2c_tmp = JHtml::_(
				'select.option', (string) 'CiviCRM not installed',
				JText::alt(trim((string) 0), preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)),
				'value', 'text',
				((string) false)
			);

			$j2c_tmp->class = (string) '';
			$j2c_tmp->onclick = (string) '';

			$options[] = $j2c_tmp;

		} else {

			// CiviCRM Joomla component exists so go ahead and grab location types using api

			require_once JPATH_ROOT . '/administrator/components/com_civicrm/helpers/api.php';
			CivicrmHelperApi::civiimport('api');

			$j2c_system_location_types = civicrm_api3('Email', 'getoptions', [
				'field' => "location_type_id",
			]);

			if ($j2c_system_location_types['count']) {
				$j2c_locationtypes = $j2c_system_location_types['values'];
				$j2c_locationtypekeys = array_keys($j2c_locationtypes);
				$j2c_keycount = count($j2c_locationtypekeys);

				for ($j2c_key=0; $j2c_key<$j2c_keycount; $j2c_key++) {
					$j2c_lockey = $j2c_locationtypekeys[$j2c_key];
					$j2c_locval = $j2c_locationtypes[$j2c_lockey];

					$j2c_tmp = JHtml::_(
						'select.option', (string) $j2c_lockey,
						JText::alt(trim((string) $j2c_locval), preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)),
						'value', 'text',
						((string) false)
					);

					$j2c_tmp->class = (string) '';
					$j2c_tmp->onclick = (string) '';

					$options[] = $j2c_tmp;

				}

			}
		}

		reset($options);

		return $options;
	}
}


