<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Privacy\Table\BlockedTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var CBplug_cbprivacy $this
 * @var int              $total
 * @var BlockedTable[]   $rows
 * @var array            $input
 * @var UserTable        $user
 * @var cbPageNav        $pageNav
 * @var bool             $searching
 */

global $_CB_framework, $_PLUGINS;

$pageTitle		=	CBTxt::T( 'Blocked Users' );

if ( $pageTitle ) {
	$_CB_framework->setPageTitle( $pageTitle );
}

initToolTip();
?>
<div class="privacyBlocked privacyBlockedDefault">
	<?php echo implode( '', $_PLUGINS->trigger( 'privacy_onBeforeDisplayBlocked', array( &$rows, &$input, $user ) ) ); ?>
	<?php if ( $pageTitle ) { ?>
	<div class="mb-3 border-bottom cb-page-header privacyBlockedTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo $pageTitle; ?></h3></div>
	<?php } ?>
	<div class="mb-2 row no-gutters pkbHeader privacyBlockedHeader">
		<div class="col-sm text-center text-sm-left">
			<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'blocked', 'func' => 'block' ) ); ?>" method="post" name="privacyBlockedForm" class="m-0 privacyBlockedForm">
				<div class="input-group">
					<input type="text" id="block" name="block" class="form-control" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'PRIVACY_BLOCK_USERNAME', 'Username' ) ); ?>" />
					<div class="input-group-append">
						<button type="submit" class="btn btn-success"><?php echo CBTxt::T( 'Block' ); ?></button>
					</div>
				</div>
			</form>
		</div>
		<?php if ( $input['search'] ) { ?>
		<div class="offset-sm-2 col-sm-4 mt-1 mt-sm-0 text-sm-right" role="search">
			<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'blocked' ) ); ?>" method="post" name="privacyBlockedForm" class="m-0 privacyBlockedForm">
				<?php echo $pageNav->getLimitBox( false ); ?>
				<div class="input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><span class="fa fa-search"></span></span>
					</div>
					<?php echo $input['search']; ?>
				</div>
			</form>
		</div>
		<?php } ?>
	</div>
	<div class="privacyBlockedRows" role="grid">
		<?php
		$i				=	0;

		if ( $rows ) foreach ( $rows as $row ) {
			$i++;

			$cbUser		=	CBuser::getInstance( $row->get( 'block', 0, GetterInterface::INT ), false );
		?>
		<?php if ( ( $i > 1 ) || ( ( $i > 1 ) && ( $i == count( $rows ) ) ) ) { ?>
		<hr class="mt-1 mb-1" role="presentation" />
		<?php } ?>
		<div class="media privacyBlockedRow" role="row">
			<div class="media-left privacyBlockedRowImg" role="gridcell">
				<?php echo $cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true ); ?>
			</div>
			<div class="pl-2 media-body privacyBlockedRowDetails" role="gridcell">
				<div class="row no-gutters">
					<div class="text-wrap col-sm privacyBlockedRowDetailsUser">
						<?php echo $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ); ?>
						<div class="privacyBlockedRowDetailsDate"><?php echo cbFormatDate( $row->getString( 'date', '' ) ); ?></div>
					</div>
					<div class="col-sm-auto align-self-center privacyBlockedRowDetailsMenu">
						<a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( '<?php echo addslashes( CBTxt::T( 'Are you sure you want to unblock this user?' ) ); ?>' ).done( function() { window.location.href = '<?php echo addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'blocked', 'func' => 'unblock', 'id' => $row->get( 'block', 0, GetterInterface::INT ) ) ) ); ?>'; })" class="btn btn-sm btn-sm-block btn-light border privacyButton privacyButtonUnblock">
							<?php echo CBTxt::T( 'Unblock' ); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<?php } else { ?>
		<div class="privacyBlockedRow privacyBlockedRowEmpty" role="row">
		<?php if ( $searching ) { ?>
			<?php echo CBTxt::T( 'No blocked user search results found.' ); ?>
		<?php } else { ?>
			<?php echo CBTxt::T( 'You currently are not blocking any users.' ); ?>
		<?php } ?>
		</div>
		<?php } ?>
	</div>
	<?php if ( $this->params->get( 'profile_blocking_paging', true, GetterInterface::BOOLEAN ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="privacyBlockedPaging">
		<?php echo $pageNav->getListLinks(); ?>
	</div>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'privacy_onAfterDisplayBlocked', array( $rows, $input, $user ) ) ); ?>
</div>