<?php
/**
 * @package	RSMembership!
 * @copyright	(c) 2009 - 2016 RSJoomla!
 * @link		https://www.rsjoomla.com
 * @license	GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

$css_status = ( $this->membership->status == 0 ? 'success' : ( $this->membership->status == 1 ? 'warning' : 'important' ) );
?>
<div class="item-page" id="rsm_mymembership_container">
	<div class="page-header">
		<h1>
			<span class="rsme_faded"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP'); ?>:</span> <?php echo $this->escape($this->membership->name); ?>
			<?php if ($this->params->get('show_status', 1)) { ?>
				<sup class="label label-<?php echo $css_status; ?> rsmemgrid-badge"><?php echo JText::_('COM_RSMEMBERSHIP_STATUS_'.$this->membership->status); ?></sup>
			<?php } ?>
		</h1>
	</div>

	<form method="post" action="<?php echo JRoute::_('index.php?option=com_rsmembership&task=mymembership.upgrade&cid='.$this->membership->id); ?>" name="membershipForm" id="rsm_membership_form">
		<!-- Membership Info -->
		<div id="rsme_membership_info">
			<!-- Membership Start - End -->
			<?php if ($this->params->get('show_expire', 1)) { ?>
			<div class="rsmemgrid-row rsmemgrid-no-gutters">
				<div class="rsmemgrid-col-md-6 rsmemgrid-float-left">
					<span class="rsmemgrid-float-left rsme_faded"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_START'); ?>: </span>
					<strong><?php echo RSMembershipHelper::showDate($this->membership->membership_start); ?></strong>
				</div>
				<div class="rsmemgrid-col-md-6 rsmemgrid-float-left">
					<span class="rsmemgrid-float-left rsme_faded"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_END'); ?>: </span>
					<strong><?php echo $this->membership->membership_end != '0000-00-00 00:00:00' ? RSMembershipHelper::showDate($this->membership->membership_end) : JText::_('COM_RSMEMBERSHIP_UNLIMITED'); ?></strong>
				</div>
			</div>
			<?php } ?>
			<!-- Membership Renew -->
			<div class="rsmemgrid-row rsmemgrid-no-gutters rsmemgrid-mt-3">
			<?php
				$unlimited = (bool) ($this->membership->status == 0 && $this->membership->membership_end == '0000-00-00 00:00:00');
				if (!$this->membership->no_renew && !$unlimited) {
			?>

				<div class="rsmemgrid-float-left rsmemgrid-col-md-6">
					<span class="rsme_faded rsme_vcenter"><?php echo JText::_('COM_RSMEMBERSHIP_RENEW'); ?>: </span>

					<?php if ($this->params->get('show_price', 1)) { ?>
						<div id="rsme_renewal_price" class="rsme_vcenter">
						<?php if ( $this->membership->use_renewal_price ) { ?>
							<?php echo  RSMembershipHelper::getPriceFormat($this->membership->renewal_price); ?>
						<?php } else { ?>
							<?php echo  RSMembershipHelper::getPriceFormat($this->membership->price); ?>
						<?php } ?>
						</div>
					<?php } ?>

					<?php $renew_link = JRoute::_('index.php?option=com_rsmembership&view=mymembership&layout=renew&cid='.$this->membership->id.':'.JFilterOutput::stringURLSafe($this->membership->name)); ?>
					<?php if ($this->membership->status == 2 || $this->membership->status == 3) { ?>
							<a class="btn btn-success btn-small rsmemgrid-btn rsmemgrid-btn-sm rsme_vcenter" href="<?php echo $renew_link; ?>"><i class="icon-white icon-refresh"></i> <?php echo JText::_('COM_RSMEMBERSHIP_RENEW'); ?></a>
					<?php } elseif ($this->membership->status == 0 && RSMembershipHelper::getConfig('allow_renew_in_advance', 1)) { ?>
							<a class="btn btn-success btn-small rsmemgrid-btn rsmemgrid-btn-sm rsme_vcenter" href="<?php echo $renew_link; ?>"><i class="icon-white icon-refresh"></i> <?php echo JText::_('COM_RSMEMBERSHIP_RENEW_IN_ADVANCE'); ?></a>
					<?php } ?>
				</div>

			<?php } ?>

			<!-- Membership Cancel Subscriptions -->
			<?php if ($this->params->get('show_cancel_subscription', 1)) { ?>
				<?php if ($this->membership->status == 0) { ?>
					<div class="rsmemgrid-float-right rsmemgrid-col-md-6">
						<a class="btn btn-danger btn-small rsmemgrid-btn rsmemgrid-btn-sm rsmemgrid-float-left rsme_vcenter" onclick="return confirm('<?php echo JText::_('COM_RSMEMBERSHIP_CONFIRM_CANCEL'); ?>')" href="<?php echo JRoute::_('index.php?option=com_rsmembership&task=cancel&cid='.$this->membership->id); ?>"><i class="icon-white icon-trash"></i> <?php echo JText::_('COM_RSMEMBERSHIP_CANCEL'); ?></a>
					</div>
				<?php } ?>
			<?php } ?>
			</div>
			
			<!-- Membership Fields -->
			<?php if (count($this->membership_fields)) { ?>
				<h3 class="page-header rsmemgrid-mt-5"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_INFORMATION'); ?></h3>

				<?php foreach ($this->membership_fields as $field) {
					$hidden = (isset($field[2]) && $field[2] == 'hidden') ? true : false;
				?>
					<div class="rsmemgrid-form-group rsmemgrid-row rsmemgrid-no-gutters rsmemgrid-mb-0 rsmemgrid-pt-1"<?php echo ($hidden ? ' style="display:none"':'')?>>
						<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
						<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo trim($field[1]) == '' ? '--' : $field[1]; ?></div></div>
					</div>
				<?php } ?>

			<?php } ?>
			<!-- Membership Upgrade -->
			<?php if ($this->has_upgrades && $this->membership->status == MEMBERSHIP_STATUS_ACTIVE) { ?>
			<div class="rsmemgrid-row rsmemgrid-no-gutters rsmemgrid-mt-3">
				<div class="rsmemgrid-float-left rsmemgrid-col-md-12" id="rsme_upgrade_box">
					<span class="rsme_vcenter rsme_faded"><label for="to_id"><?php echo JText::_('COM_RSMEMBRSHIP_UPGRADE_TO'); ?></label></span>
					<span class="rsme_vcenter"><?php echo $this->lists['upgrades']; ?> </span>
					<span class="rsme_vcenter"><button type="submit" class="btn btn-small btn-success rsmemgrid-btn rsmemgrid-btn-sm"><?php echo JText::_('COM_RSMEMBERSHIP_UPGRADE'); ?></button></span>
				</div>
			</div>
			<?php } ?>

		<!-- Bought Extras -->
		<?php if (!empty($this->boughtextras)) { ?>
			<div class="rsmemgrid-row rsmemgrid-no-gutters rsme_extrab_container">
				<div class="rsmemgrid-col-md-12">
					<p class="lead"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_EXTRA_BOUGHT'); ?></p>
					<div class="rsmemgrid-float-left">
						<?php foreach ($this->boughtextras as $bought_extra) { ?>
							<?php foreach ($bought_extra as $id => $extraname) { ?>
								<span class="label label-success rsmemgrid-badge"><i class="rsmemgrid-icon rsmemgrid-icon-checkmark"></i> <?php echo $extraname; ?></span>
							<?php } ?>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php } ?>
		<!-- Available Extras -->
		<?php if (!empty($this->extras)) { ?>
			<div class="rsmemgrid-row rsmemgrid-no-gutters rsme_extra_container">
				<div class="rsmemgrid-col-md-12">
					<p class="lead"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_EXTRA'); ?>:</p>
					<div>
					<?php foreach ( $this->extras as $extra ) { ?>
						<?php if ( $extra->type != 'checkbox' && isset($this->boughtextras[$extra->extra_id]) ) continue; ?>
							 <a class="btn btn-small rsmemgrid-btn rsmemgrid-btn-sm rsme_extra_btn" href="<?php echo JRoute::_('index.php?option=com_rsmembership&view=mymembership&layout=addextra&cid='.$this->membership->id.':'.JFilterOutput::stringURLSafe($this->membership->name).'&extra_id='.$extra->id); ?>"><span class="rsmemgrid-icon rsmemgrid-icon-plus"></span> <?php echo JText::sprintf('COM_RSMEMBERSHIP_PURCHASE_EXTRA', $extra->name); ?></a>
					<?php } ?>
					</div>
				</div>
			</div>
		<?php } ?>
		
		<!-- Terms & Conditions -->
		<?php if (!empty($this->membershipterms->id)) { ?>
			<p class="lead"><?php echo JText::_('COM_RSMEMBERSHIP_TERM'); ?></p>
			<a class="btn btn-info rsmemgrid-btn" href="<?php echo JRoute::_('index.php?option=com_rsmembership&view=terms&cid='.$this->membershipterms->id.':'.JFilterOutput::stringURLSafe($this->membershipterms->name)); ?>"><i class="rsmemgrid-icon rsmemgrid-icon-eye"></i> <?php echo $this->membershipterms->name; ?></a>
		<?php } ?>
		<!-- Not active reason -->
		<?php if ($this->membership->status > 0) { ?>
		<p><?php echo JText::sprintf('COM_RSMEMBERSHIP_NOT_ACTIVE', JText::_('COM_RSMEMBERSHIP_STATUS_'.$this->membership->status)); ?></p>
		<?php } ?>
		<div class="clearfix"></div>

		<?php if ($this->previous !== false || !empty($this->folders) || !empty($this->files)) { ?>
		<p class="lead"><?php echo JText::_('COM_RSMEMBERSHIP_FILES_AVAILABLE'); ?></p>
		<table class="table table-striped">
		<?php if ($this->params->get('show_headings', 1)) { ?>
			<tr>
				<th width="1%" class="sectiontableheader<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>">&nbsp;</th>
				<th class="sectiontableheader<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>"><?php echo JText::_('COM_RSMEMBERSHIP_NAME'); ?></th>
			</tr>
		<?php } ?>
		<?php if ($this->previous !== false) { ?>
			<tr class="sectiontableentry1<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>" >
				<td align="center" valign="top"><?php echo '<i class="icon-folder-open"></i>'; ?></td>
				<td><a href="<?php echo JRoute::_('index.php?option=com_rsmembership&view=mymembership&cid='.$this->cid.($this->previous != '' ? '&path='.$this->previous.'&from='.$this->from : '')); ?>">..</a></td>
			</tr>
		<?php } ?>
		<?php foreach ($this->folders as $folder) {
			if (RSMembershipHelper::getConfig('trigger_content_plugins') && isset($folder->description)) {
				$folder->description = JHtml::_('content.prepare', $folder->description);
			}
			$image = !empty($folder->thumb) ? JHtml::image('components/com_rsmembership/assets/thumbs/files/'.$folder->thumb, '', 'width="'.$folder->thumb_w.'"') : '<i class="icon-folder-close"></i>';
			?>
			<tr class="sectiontableentry1<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>" >
				<td align="center" valign="top"><?php echo $image; ?></td>
				<td><a href="<?php echo JRoute::_('index.php?option=com_rsmembership&view=mymembership&cid='.$this->cid.'&path='.$folder->fullpath.'&from='.$folder->from); ?>"><?php echo !empty($folder->name) ? $folder->name : $folder->fullpath; ?></a><?php if (!empty($folder->description)) { ?><p><?php echo $folder->description; ?></p><?php } ?></td>
			</tr>
		<?php } ?>
		<?php foreach ($this->files as $file) {
			if (RSMembershipHelper::getConfig('trigger_content_plugins') && isset($file->description)) {
				$file->description = JHtml::_('content.prepare', $file->description);
			}
			$image = !empty($file->thumb) ? JHtml::image('components/com_rsmembership/assets/thumbs/files/'.$file->thumb, '', 'width="'.$file->thumb_w.'"') : '<i class="icon-file"></i>'; ?>
			<tr class="sectiontableentry1<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>" >
				<td align="center" valign="top"><?php echo $image; ?></td>
				<td><a href="<?php echo JRoute::_('index.php?option=com_rsmembership&task=download&cid='.$this->cid.'&path='.$file->fullpath.'&from='.$file->from); ?>"><?php echo !empty($file->name) ? $file->name : $file->fullpath; ?></a><?php if (!empty($file->description)) { ?><p><?php echo $file->description; ?></p><?php } ?></td>
			</tr>
		<?php } ?>
		</table>
		<?php } ?>

		</div>
		<?php echo JHtml::_('form.token'); ?>
		<input type="hidden" name="option" value="com_rsmembership" />
		<input type="hidden" name="view" value="mymembership" />
		<input type="hidden" name="task" value="mymembership.upgrade" />
		<input type="hidden" name="cid" value="<?php echo $this->membership->id; ?>" />
	</form>
</div>