<?php
/**
 * @package	RSMembership!
 * @copyright	(c) 2009 - 2020 RSJoomla!
 * @link		https://www.rsjoomla.com
 * @license	GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
?>
<div id="rsm_subscribe_payment">
	<div class="item-page">
		<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_PAYMENT_INFORMATION'); ?></h3>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-d-flex rsmemgrid-align-items-center rsmemgrid-col-form-label"><label><?php echo  JText::_('COM_RSMEMBERSHIP_PAY_WITH'); ?>:</label></div>
			<div class="rsmemgrid-col-sm-8">
			<?php
			$i = 0;
			if ( !empty($this->payments) )
			{
				foreach ($this->payments as $plugin => $paymentdetails) {
					$i++;
					$tax_value = '';
					$paymentname = '';
					if (is_array($paymentdetails))
					{
						if ($paymentdetails['tax_details'])
						{
							if ($paymentdetails['tax_details']['tax_type'] == 0)
							{
								$tax_value = $this->total * ($paymentdetails['tax_details']['tax_value'] / 100);
								$tax_value = JText::sprintf('COM_RSMEMBERSHIP_PAY_TAX_VALUE_PERCENT', $tax_value,RSMembershipHelper::getPriceFormat($tax_value), $paymentdetails['tax_details']['tax_value']);
							}
							else
							{
								$tax_value = JText::sprintf('COM_RSMEMBERSHIP_PAY_TAX_VALUE_FIXED', $paymentdetails['tax_details']['tax_value'], RSMembershipHelper::getPriceFormat($paymentdetails['tax_details']['tax_value']));
							}
						}
						$paymentname = $paymentdetails['name'];
					}
					else
					{
						$paymentname = $paymentdetails;
					}
					?>
					<div class="rsmemgrid-form-group rsmemgrid-form-check">
						<input <?php echo $i == 1 ? 'checked="checked"' : ''; ?> type="radio" name="payment" value="<?php echo $this->escape($plugin); ?>" id="payment<?php echo $i; ?>" class="rsmemgrid-form-check-input" />
						<label for="payment<?php echo $i; ?>" class="rsmemgrid-form-check-label"><?php echo $this->escape($paymentname).$tax_value; ?></label>
					</div>
				<?php } ?>
			<?php } ?>
			</div>
		</div>
	</div>
	<div class="item-page">
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><strong><?php echo JText::_('COM_RSMEMBERSHIP_GRAND_TOTAL'); ?></strong>:</label></div>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><span id="rsm_grand_total" data-fixedvalue="<?php echo $this->grand_total;?>"><?php echo RSMembershipHelper::getPriceFormat($this->total); ?></span></div></div>
		</div>
	</div>
</div>