<?php
/**
 * @package	RSMembership!
 * @copyright	(c) 2009 - 2016 RSJoomla!
 * @link		https://www.rsjoomla.com
 * @license	GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

$chunks = array_chunk($this->items, $this->params->get('columns_no', 2));
?>
<div id="rsm_memberships" class="item-page">
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
	<div class="page-header">
		<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
	</div>
	<?php } ?>
	<?php
	foreach ($chunks as $items)
	{
		$column_size = 12 / count($items);
		?>
		<div class="rsmemgrid-row">
		<?php
			foreach ($items as $item) 
			{
				$link  		= JRoute::_( RSMembershipRoute::Membership($item->id, $this->Itemid) );
				$apply_link = JRoute::_( RSMembershipRoute::Subscribe( $item->category_id, $item->category_name, $item->id, $item->name, $this->Itemid ) );

				$price 		= RSMembershipHelper::getPriceFormat($item->price);
				$image 		= !empty($item->thumb) ? JHtml::image('components/com_rsmembership/assets/thumbs/'.$item->thumb, $item->name, 'class="rsm_thumb"') : '';

				$placeholders = array(
					'{price}' 	=> $price,
					'{buy}'		=> '',
					'{extras}'  => '',
					'{stock}'	=> ($item->stock > -1 ? ( $item->stock == 0 ? JText::_('COM_RSMEMBERSHIP_UNLIMITED') : $item->stock) : JText::_('COM_RSMEMBERSHIP_OUT_OF_STOCK_PLACEHOLDER')) ,
					'<hr id="system-readmore" />' => ''
				);
				
				// Trigger content plugins if enabled
				if (RSMembershipHelper::getConfig('trigger_content_plugins')) {
					$item->description = JHtml::_('content.prepare', $item->description);
				}
				
				$item->description = str_replace(array_keys($placeholders), array_values($placeholders), $item->description);
				?>
					<div class="rsmemgrid-col-md-<?php echo $column_size; ?> rsm_container<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>">
						<div class="rsmemgrid-card">
							<div class="rsm_thumbnail"><?php echo $image; ?></div>
							<div class="rsmemgrid-card-body">
								<h2 class="rsm_title rsmemgrid-card-title"><?php if ($this->params->get('show_category', 0)) { ?><?php echo $item->category_id ? $item->category_name : JText::_('COM_RSMEMBERSHIP_NO_CATEGORY'); ?> - <?php } ?><a href="<?php echo $link; ?>"><?php echo $item->name; ?></a></h2>
								<h2 class="rsm_title"><small><?php echo $price; ?></small></h2>
								<?php echo $item->description; ?>
								<div class="rsmemgrid-clearfix"></div>

									<div class="btn-group rsmemgrid-btn-group">
										<?php if ($this->params->get('show_buttons', 2) == 1 || $this->params->get('show_buttons', 2) == 2) { ?>
											<a href="<?php echo $link; ?>" class="btn rsmemgrid-btn"><?php echo JText::_('COM_RSMEMBERSHIP_DETAILS'); ?></a>
										<?php } ?>

										<?php if (($this->params->get('show_buttons', 2) == 2 || $this->params->get('show_buttons', 2) == 3) && $item->stock != -1) { ?>
											<a href="<?php echo $apply_link; ?>" class="btn btn-success rsmemgrid-btn"><?php echo JText::_('COM_RSMEMBERSHIP_SUBSCRIBE'); ?></a>
										<?php } ?>
									</div>

								<div class="rsmemgrid-clearfix"></div>
							</div>
						</div>
					</div>
		<?php } ?>
		</div>
		<?php
	}
if ($this->params->get('show_pagination', 0) && $this->pagination->get('pages.total') > 1) { ?>
	<div class="pagination">
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php echo $this->pagination->getPagesCounter(); ?>
<?php } ?>
	<div class="rsmemgrid-clearfix"></div>
</div>