<?php
/**
 * @package	RSMembership!
 * @copyright	(c) 2009 - 2016 RSJoomla!
 * @link		https://www.rsjoomla.com
 * @license	GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

JText::script('COM_RSMEMBERSHIP_THERE_WAS_AN_ERROR');
if (!empty($this->membershipterms)) {
    JText::script('COM_RSMEMBERSHIP_PLEASE_AGREE_MEMBERSHIP');
}
?>
<div id="rsm_mymembership_upgrade">
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php } ?>
	<form method="post" class="rsmembership_form" action="<?php echo JRoute::_('index.php?option=com_rsmembership&task=mymembership.upgradepaymentredirect'); ?>" name="membershipForm" onsubmit="return RSMembership.subscribe.validate_subscribe(this);" id="rsm_upgrade_form">
		<div class="item-page">
			<div class="page-header"><h3><?php echo JText::_('COM_RSMEMBERSHIP_PURCHASE_INFORMATION'); ?></h3></div>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_UPGRADE'); ?>:</label></div>
				<div class="rsmemgrid-col-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->upgrade->fromname; ?> <?php echo JText::_('to'); ?> <?php echo $this->upgrade->toname; ?></div></div>
			</div>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_TOTAL_COST'); ?>:</label></div>
				<div class="rsmemgrid-col-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->total; ?></div></div>
			</div>
		</div>

		<div class="item-page">
			<div class="page-header"><h3><?php echo JText::_('COM_RSMEMBERSHIP_ACCOUNT_INFORMATION'); ?></h3></div>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_NAME'); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('name')); ?></div></div>
			</div>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_( 'COM_RSMEMBERSHIP_EMAIL' ); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('email')); ?></div></div>
			</div>
			<?php foreach ($this->fields as $field) {
				$hidden = (isset($field[2]) && $field[2] == 'hidden') ? true : false;
				?>
				<div class="rsmemgrid-form-group rsmemgrid-row"<?php echo ($hidden ? ' style="display:none"':'')?>>
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
					<div class="rsmemgrid-col-sm-8"><?php echo $field[1]; ?></div>
				</div>
			<?php } ?>
		</div>

		<?php if (count($this->membership_fields)) { ?>
			<div class="item-page">
				<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_INFORMATION'); ?></h3>
				<?php foreach ($this->membership_fields as $field) {
					$hidden = (isset($field[2]) && $field[2] == 'hidden') ? true : false;
					?>
					<div class="rsmemgrid-form-group rsmemgrid-row"<?php echo ($hidden ? ' style="display:none"':'')?>>
						<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
						<div class="rsmemgrid-col-sm-8"><?php echo $field[1]; ?></div>
					</div>
				<?php } ?>
			</div>
		<?php } ?>

		<?php if ($this->upgrade->price > 0) { ?>
			<div class="item-page">
				<div class="page-header"><h3><?php echo JText::_('COM_RSMEMBERSHIP_PAYMENT_INFORMATION'); ?></h3></div>
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-d-flex rsmemgrid-align-items-center rsmemgrid-col-form-label"><label><?php echo  JText::_('COM_RSMEMBERSHIP_PAY_WITH'); ?>:</label></div>
					<div class="rsmemgrid-col-sm-8">
							<?php
							$i = 0;
							if (!empty($this->payments))
							{
								foreach ($this->payments as $plugin => $paymentdetails) {
									$i++;
									$tax_value = '';
									$paymentname = '';
									if (is_array($paymentdetails))
									{
										if ($paymentdetails['tax_details'])
										{
											if ($paymentdetails['tax_details']['tax_type'] == 0)
											{
												$tax_value = $this->upgrade->price * ($paymentdetails['tax_details']['tax_value'] / 100);
												$tax_value = JText::sprintf('COM_RSMEMBERSHIP_PAY_TAX_VALUE_PERCENT', $tax_value, RSMembershipHelper::getPriceFormat($tax_value), $paymentdetails['tax_details']['tax_value']);
											}
											else
											{
												$tax_value = JText::sprintf('COM_RSMEMBERSHIP_PAY_TAX_VALUE_FIXED', $paymentdetails['tax_details']['tax_value'], RSMembershipHelper::getPriceFormat($paymentdetails['tax_details']['tax_value']));
											}
										}
										$paymentname = $paymentdetails['name'];
									}
									else
									{
										$paymentname = $paymentdetails;
									}
									?>
						<div class="rsmemgrid-form-group rsmemgrid-form-check"><input <?php echo $i == 1 ? 'checked="checked"' : ''; ?> type="radio" name="payment" value="<?php echo $this->escape($plugin); ?>" id="payment<?php echo $i; ?>" class="rsmemgrid-form-check-input" /> <label for="payment<?php echo $i; ?>" class="rsmemgrid-form-check-label"><?php echo $this->escape($paymentname).$tax_value; ?></label></div>
								<?php } ?>
							<?php } ?>
					</div>
				</div>
			</div>
			<div class="item-page">
				<div class="rsmemgrid-form-group rsmemgrid-row">
					<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><strong><?php echo JText::_('COM_RSMEMBERSHIP_GRAND_TOTAL'); ?></strong>:</label></div>
					<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><span id="rsm_grand_total" data-fixedvalue="<?php echo $this->upgrade->price;?>"><?php echo RSMembershipHelper::getPriceFormat($this->upgrade->price); ?></span></div></div>
				</div>
			</div>
		<?php } ?>

		<?php if (!empty($this->membershipterms)) { ?>
			<div class="item-page">
				<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_TERM'); ?></h3>
				<div id="rsm_terms_frame">
					<div class="item-page">
						<div id="rsm_terms_container">
							<h1><?php echo $this->escape($this->membershipterms->name); ?></h1>
							<?php
							if (RSMembershipHelper::getConfig('trigger_content_plugins')) {
								$this->membershipterms->description = JHtml::_('content.prepare', $this->membershipterms->description);
							}
							echo $this->membershipterms->description;
							?>
						</div> <!-- rsm_terms_container -->
					</div>
				</div>
				<div class="rsmemgrid-form-group rsmemgrid-form-check rsmemgrid-mt-2">
					<input type="checkbox" id="rsm_checkbox_agree" class="rsmemgrid-form-check-input" name="i_agree_to_terms" value="1" />
					<label for="rsm_checkbox_agree" class="rsmemgrid-form-check-label"><?php echo JText::_('COM_RSMEMBERSHIP_I_AGREE'); ?> (<?php echo $this->escape($this->membershipterms->name); ?>)</label>
				</div>
			</div>
		<?php } ?>

		<div class="form-actions">
			<button type="button" class="btn rsmemgrid-btn" onclick="document.location='<?php echo JRoute::_('index.php?option=com_rsmembership&view=mymembership&cid='.$this->cid); ?>'" name="Cancel"><?php echo JText::_('COM_RSMEMBERSHIP_BACK'); ?></button>
			<button type="submit" class="btn btn-success rsmemgrid-btn rsmemgrid-float-right"><?php echo JText::_('COM_RSMEMBERSHIP_UPGRADE'); ?></button>
		</div>
		<?php echo $this->token; ?>
		<input type="hidden" name="option" value="com_rsmembership" />
		<input type="hidden" name="view" value="mymembership" />
		<input type="hidden" name="task" value="mymembership.upgradepaymentredirect" />
		<input type="hidden" name="cid" value="<?php echo $this->cid; ?>" />
		<input type="hidden" name="to_id" value="<?php echo $this->upgrade->membership_to_id ?>" />
	</form> <!-- rsm_upgrade_form -->

<?php
echo RSMembershipHelper::renderMagnificPopup('rsmembershipModal', array(
    'url' 	   => false,
    'height'   => 400
));
?>
</div>