<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		doctor.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Doctor Model
 */
class ReservationModelDoctor extends JModelItem
{
	/**
	 * Model context string.
	 *
	 * @var        string
	 */
	protected $_context = 'com_reservation.doctor';

	/**
	 * Model user data.
	 *
	 * @var        strings
	 */
	protected $user;
	protected $userId;
	protected $guest;
	protected $groups;
	protected $levels;
	protected $app;
	protected $input;
	protected $uikitComp;

	/**
	 * @var object item
	 */
	protected $item;

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 *
	 * @return void
	 */
	protected function populateState()
	{
		$this->app = JFactory::getApplication();
		$this->input = $this->app->input;
		// Get the itme main id
		$id = $this->input->getInt('id', null);
		$this->setState('doctor.id', $id);

		// Load the parameters.
		$params = $this->app->getParams();
		$this->setState('params', $params);
		parent::populateState();
	}

	/**
	 * Method to get article data.
	 *
	 * @param   integer  $pk  The id of the article.
	 *
	 * @return  mixed  Menu item data object on success, false on failure.
	 */
	public function getItem($pk = null)
	{
		$this->user = JFactory::getUser();
		$this->userId = $this->user->get('id');
		$this->guest = $this->user->get('guest');
		$this->groups = $this->user->get('groups');
		$this->authorisedGroups = $this->user->getAuthorisedGroups();
		$this->levels = $this->user->getAuthorisedViewLevels();
		$this->initSet = true;

		$pk = (!empty($pk)) ? $pk : (int) $this->getState('doctor.id');

/***[JCBGUI.dynamic_get.php_before_getitem.49.$$$$]***/
$uid= JFactory::getApplication()->input->get('uid');
$auth= ReservationHelper::doctorAuthorize($uid);
if (!$auth)
    JFactory::getApplication()->redirect(JUri::root());/***[/JCBGUI$$$$]***/

		
		if ($this->_item === null)
		{
			$this->_item = array();
		}

		if (!isset($this->_item[$pk]))
		{
			try
			{
				// Get a db connection.
				$db = JFactory::getDbo();

				// Create a new query object.
				$query = $db->getQuery(true);

				// Get from #__reservation_consultant as a
				$query->select($db->quoteName(
			array('a.id','a.asset_id','a.userid','a.nationalnumber','a.phonenumber','a.officephone','a.capitalid','a.cityid','a.account','a.introduction','a.msn','a.catid','a.experience','a.image','a.alt','a.video','a.presence','a.address','a.published','a.created_by','a.modified_by','a.created','a.modified','a.version','a.hits','a.ordering'),
			array('id','asset_id','userid','nationalnumber','phonenumber','officephone','capitalid','cityid','account','introduction','msn','catid','experience','image','alt','video','presence','address','published','created_by','modified_by','created','modified','version','hits','ordering')));
				$query->from($db->quoteName('#__reservation_consultant', 'a'));

				// Get from #__categories as c
				$query->select($db->quoteName(
			array('c.title'),
			array('categories_title')));
				$query->join('INNER', ($db->quoteName('#__categories', 'c')) . ' ON (' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('c.id') . ')');

				// Get from #__users as u
				$query->select($db->quoteName(
			array('u.id','u.name'),
			array('users_id','users_name')));
				$query->join('INNER', ($db->quoteName('#__users', 'u')) . ' ON (' . $db->quoteName('a.userid') . ' = ' . $db->quoteName('u.id') . ')');
				// Check if $uid is a string or numeric value.
				$checkValue = $uid;
				if (isset($checkValue) && ReservationHelper::checkString($checkValue))
				{
					$query->where('u.id = ' . $db->quote($checkValue));
				}
				elseif (is_numeric($checkValue))
				{
					$query->where('u.id = ' . $checkValue);
				}
				else
				{
					return false;
				}

				// Reset the query using our newly populated query object.
				$db->setQuery($query);
				// Load the results as a stdClass object.
				$data = $db->loadObject();

				if (empty($data))
				{
					$app = JFactory::getApplication();
					// If no data is found redirect to default page and show warning.
					$app->enqueueMessage(JText::_('COM_RESERVATION_NOT_FOUND_OR_ACCESS_DENIED'), 'warning');
					$app->redirect(JURI::root());
					return false;
				}
			// Load the JEvent Dispatcher
			JPluginHelper::importPlugin('content');
			$this->_dispatcher = JEventDispatcher::getInstance();
				// Check if item has params, or pass whole item.
				$params = (isset($data->params) && ReservationHelper::checkJson($data->params)) ? json_decode($data->params) : $data;
				// Make sure the content prepare plugins fire on address
				$_address = new stdClass();
				$_address->text =& $data->address; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (address) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.doctor.address', &$_address, &$params, 0));
				// Make sure the content prepare plugins fire on presence
				$_presence = new stdClass();
				$_presence->text =& $data->presence; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (presence) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.doctor.presence', &$_presence, &$params, 0));
				// Make sure the content prepare plugins fire on introduction
				$_introduction = new stdClass();
				$_introduction->text =& $data->introduction; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (introduction) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.doctor.introduction', &$_introduction, &$params, 0));

				// set data object to item.
				$this->_item[$pk] = $data;
			}
			catch (Exception $e)
			{
				if ($e->getCode() == 404)
				{
					// Need to go thru the error handler to allow Redirect to work.
					JError::raiseWarning(404, $e->getMessage());
				}
				else
				{
					$this->setError($e);
					$this->_item[$pk] = false;
				}
			}
		}

/***[JCBGUI.dynamic_get.php_after_getitem.49.$$$$]***/
$did= $this->_item[$pk]->id;
$this->_item[$pk]->appointments= $this->getAppointment($did);/***[/JCBGUI$$$$]***/


		return $this->_item[$pk];
	}


/***[JCBGUI.site_view.php_model.35.$$$$]***/
 public function getAppointment($did)
    {
        $db= JFactory::getDbo();
        $query= $db->getQuery(true)
            ->select('id, date(appointment) as apoDate, title')
            ->from($db->quoteName('#__reservation_appointment'))
            ->where($db->quoteName('doctorid').'='.$did)
            ->where($db->quoteName('appointment').'> UTC_TIMESTAMP')
            ->order('appointment asc');

        $db->setQuery($query);
        $result= $db->loadObjectList();
        return $result;

    }/***[/JCBGUI$$$$]***/

}
