<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		consultantitem.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Consultantitem Model
 */
class ReservationModelConsultantitem extends JModelItem
{
	/**
	 * Model context string.
	 *
	 * @var        string
	 */
	protected $_context = 'com_reservation.consultantitem';

	/**
	 * Model user data.
	 *
	 * @var        strings
	 */
	protected $user;
	protected $userId;
	protected $guest;
	protected $groups;
	protected $levels;
	protected $app;
	protected $input;
	protected $uikitComp;

	/**
	 * @var object item
	 */
	protected $item;

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 *
	 * @return void
	 */
	protected function populateState()
	{
		$this->app = JFactory::getApplication();
		$this->input = $this->app->input;
		// Get the itme main id
		$id = $this->input->getInt('id', null);
		$this->setState('consultantitem.id', $id);

		// Load the parameters.
		$params = $this->app->getParams();
		$this->setState('params', $params);
		parent::populateState();
	}

	/**
	 * Method to get article data.
	 *
	 * @param   integer  $pk  The id of the article.
	 *
	 * @return  mixed  Menu item data object on success, false on failure.
	 */
	public function getItem($pk = null)
	{
		$this->user = JFactory::getUser();
		$this->userId = $this->user->get('id');
		$this->guest = $this->user->get('guest');
		$this->groups = $this->user->get('groups');
		$this->authorisedGroups = $this->user->getAuthorisedGroups();
		$this->levels = $this->user->getAuthorisedViewLevels();
		$this->initSet = true;

		$pk = (!empty($pk)) ? $pk : (int) $this->getState('consultantitem.id');
		
		if ($this->_item === null)
		{
			$this->_item = array();
		}

		if (!isset($this->_item[$pk]))
		{
			try
			{
				// Get a db connection.
				$db = JFactory::getDbo();

				// Create a new query object.
				$query = $db->getQuery(true);

				// Get from #__reservation_consultant as a
				$query->select($db->quoteName(
			array('a.id','a.userid','a.experience','a.image','a.alt','a.msn','a.catid','a.video','a.introduction'),
			array('id','userid','experience','image','alt','msn','catid','video','introduction')));
				$query->from($db->quoteName('#__reservation_consultant', 'a'));

				// Get from #__users as u
				$query->select($db->quoteName(
			array('u.name'),
			array('users_name')));
				$query->join('INNER', ($db->quoteName('#__users', 'u')) . ' ON (' . $db->quoteName('a.userid') . ' = ' . $db->quoteName('u.id') . ')');

				// Get from #__categories as c
				$query->select($db->quoteName(
			array('c.title'),
			array('categories_title')));
				$query->join('INNER', ($db->quoteName('#__categories', 'c')) . ' ON (' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('c.id') . ')');
				$query->where('a.id = ' . (int) $pk);
				// Get where a.published is 1
				$query->where('a.published = 1');

				// Reset the query using our newly populated query object.
				$db->setQuery($query);
				// Load the results as a stdClass object.
				$data = $db->loadObject();

				if (empty($data))
				{
					$app = JFactory::getApplication();
					// If no data is found redirect to default page and show warning.
					$app->enqueueMessage(JText::_('COM_RESERVATION_NOT_FOUND_OR_ACCESS_DENIED'), 'warning');
					$app->redirect(JURI::root());
					return false;
				}
			// Load the JEvent Dispatcher
			JPluginHelper::importPlugin('content');
			$this->_dispatcher = JEventDispatcher::getInstance();
				// Check if item has params, or pass whole item.
				$params = (isset($data->params) && ReservationHelper::checkJson($data->params)) ? json_decode($data->params) : $data;
				// Make sure the content prepare plugins fire on introduction
				$_introduction = new stdClass();
				$_introduction->text =& $data->introduction; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (introduction) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.consultantitem.introduction', &$_introduction, &$params, 0));

				// set data object to item.
				$this->_item[$pk] = $data;
			}
			catch (Exception $e)
			{
				if ($e->getCode() == 404)
				{
					// Need to go thru the error handler to allow Redirect to work.
					JError::raiseWarning(404, $e->getMessage());
				}
				else
				{
					$this->setError($e);
					$this->_item[$pk] = false;
				}
			}
		}

/***[JCBGUI.dynamic_get.php_after_getitem.41.$$$$]***/
$this->_item[$pk]->sessionCount= $this->getSessionCount($pk)->count;
$this->_item[$pk]->plans= $this->getplans($pk);
$this->_item[$pk]->comments= $this->getComments($pk);/***[/JCBGUI$$$$]***/


		return $this->_item[$pk];
	}


/***[JCBGUI.site_view.php_model.27.$$$$]***/
  public function getSessionCount($pk)
    {

        // select number of sessions performed by consultants
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query
            ->select(' COUNT(*) as count')
            ->from($db->quoteName('#__reservation_session', 's'))
            ->join('INNER', $db->quoteName('#__reservation_plan', 'p') . ' ON ' . $db->quoteName('s.planid') . ' = ' . $db->quoteName('p.id'))
            ->join('INNER', $db->quoteName('#__reservation_consultant', 'co') . ' ON ' . $db->quoteName('p.consultantid') . ' = ' . $db->quoteName('co.id'))
            ->where($db->quoteName('s.pay').'= 1')
            ->where($db->quoteName('co.id').'= '.$pk.' ');



        $db->setQuery($query);


        $sessionCount = $db->loadObject();
        return $sessionCount;
	}


public function getplans($pk)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query
            ->select(array('id','plantype','time','price','waitingtime'))
            ->from($db->quoteName('#__reservation_plan', 'p'))
            ->where($db->quoteName('p.consultantid').'= '.$pk.' ')
            ->where($db->quoteName('p.published').'= 1 ');



        $db->setQuery($query);


        $pt= array(
            1 => 'COM_RESERVATION_PLAN_TEL',
            2 => 'COM_RESERVATION_PLAN_CHAT'
        );


        $plans = $db->loadObjectList();

       
        return $plans;
    }
  public function getComments($pk)
    {
        $db= JFactory::getDbo();
        $query= $db->getQuery(true)
            ->select($db->quoteName(array('cm.text','u.name','cm.created','si.image','si.alt', 'cm.rate'),array('text','name','created','image','alt', 'rate')))
            ->from($db->quoteName('#__reservation_comment','cm'))
            ->join('INNER', $db->quoteName('#__reservation_sick', 'si') . ' ON ' . $db->quoteName('si.id') . ' = ' . $db->quoteName('cm.sickid'))
            ->join('INNER', $db->quoteName('#__users', 'u') . ' ON ' . $db->quoteName('si.userid') . ' = ' . $db->quoteName('u.id'))
            ->where($db->quoteName('cm.consultantid').'='.$pk)
            ->where($db->quoteName('cm.published').'= 1')
            ->order('cm.created DESC');

        $db->setQuery($query);
        $result = $db->loadObjectList();
        return $result;
    }/***[/JCBGUI$$$$]***/

}
