<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		consultant_plan.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Consultant_plan Controller
 */
class ReservationControllerConsultant_plan extends JControllerForm
{
	/**
	 * Current or most recently performed task.
	 *
	 * @var    string
	 * @since  12.2
	 * @note   Replaces _task.
	 */
	protected $task;

	public function __construct($config = array())
	{
		$this->view_list = 'login'; // safeguard for setting the return view listing to the default site view.
		parent::__construct($config);
	}


/***[JCBGUI.site_view.php_controller.37.$$$$]***/
  public function delete($key = NULL, $urlVar = NULL)
  {
    $app= JFactory::getApplication();
    $uri= (string)JUri::getInstance();
    $user= JFactory::getUser();
    $jform= $app->input->get('jform',array(),'array');


    $consultant= ReservationHelper::getConsultant($jform['consultantid']);

    if ($consultant->userid != $user->get('id', 0))
      $app->redirect(JUri::root());


    $filename = __DIR__ . '/delete.txt';


    $plans = array_keys($jform['plans']);
    $plans = array_map(function ($a) { return intval(substr($a, 5)); }, $plans);

    // file_put_contents($filename, 'plans = ' . print_r($plans, true) . "\n" , FILE_APPEND);



    JLoader::register('ReservationModelPlan', JPATH_ADMINISTRATOR . '/components/com_reservation/models/plan.php');
    JLoader::register('ReservationTablePlan', JPATH_ADMINISTRATOR . '/components/com_reservation/tables/plan.php');
    JPluginHelper::importPlugin('reservation');
    $dispatcher = JEventDispatcher::getInstance();
    foreach($plans as $pid)
    {
      $db = JFactory::getDbo();
      $planmodel = new ReservationTablePlan($db);
      $pkco = array(
        'id' => $pid
      );
      $planmodel->publish($pkco, -2);
      $pks = array($pid);
      $dispatcher->trigger('onReservationPlanStateChanged', array($pks, -2));
      $planmodel->delete($pkco);
    }




    $app->redirect($uri);
  }
  public function save($key = NULL, $urlVar = NULL)
  {
    $filename = __DIR__ . '/save.txt';
    // file_put_contents($filename, 'key = ' . print_r($key, true) . "\n" , FILE_APPEND);


    $uri= (string)JUri::getInstance();
    $user= JFactory::getUser();
    $app= JFactory::getApplication();
    $jform= $app->input->get('jform',array(),'array');


    $consultant= ReservationHelper::getConsultant($jform['consultantid']);

    if ($consultant->userid != $user->get('id', 0))
      $app->redirect(JUri::root());

    JLoader::register('ReservationModelPlan', JPATH_ADMINISTRATOR.'/components/com_reservation/models/plan.php');
    if(isset($jform['planid']) && $jform['planid'])
    {
      $jform['id'] = $jform['planid'];
      $planmodel = new ReservationModelPlan();
      $planObj = $planmodel->getItem($jform['id']);
      $consultant= ReservationHelper::getConsultant($planObj->consultantid);
      if ($consultant->userid != $user->get('id', 0))
        $app->redirect(JUri::root());
    }
    unset($jform['planid']);

    // file_put_contents($filename, 'jform = ' . print_r($jform, true) . "\n" , FILE_APPEND);

    $planmodel= new ReservationModelPlan;
    if (!$planmodel->save($jform))
    {
      $app->enqueueMessage(JText::_('COM_RESERVATION_FAILED_TO_SAVE_PLAN', 'danger')); // failed to save plan
      $app->redirect($uri);
    }

    $validData = (array)$planmodel->getItem();

    JPluginHelper::importPlugin('reservation');
    $dispatcher = JEventDispatcher::getInstance();
    $dispatcher->trigger('onReservationPlanCreated', array($validData));


    $app->enqueueMessage(JText::_('COM_RESERVATION_PLAN_SAVED_SUCCESSFULLY', 'success')); // plan saved successfully
    $app->redirect($uri);
  }
/***[/JCBGUI$$$$]***/


	/**
	 * Method to check if you can edit an existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

        /**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	protected function allowAdd($data = array())
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Method to check if you can save a new or existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowSave($data, $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Function that allows child controller access to model data
	 * after the data has been saved.
	 *
	 * @param   JModelLegacy  $model      The data model object.
	 * @param   array         $validData  The validated data.
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
	}
}
