<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveEvents\Table\EventTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveEvents
{

	/**
	 * render frontend events
	 *
	 * @param EventTable[]    $rows
	 * @param cbPageNav       $pageNav
	 * @param bool            $searching
	 * @param array           $input
	 * @param array           $counters
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showEvents( $rows, $pageNav, $searching, $input, &$counters, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$_CB_framework->outputCbJQuery( "$( '.gjGroupEventDescription .cbMoreLess' ).cbmoreless();", 'cbmoreless' );

		if ( $pageNav->total ) {
			$counters[]							=	'<span class="fa-before fa-calendar gjGroupEventsIcon"> ' . CBTxt::T( 'GROUP_EVENTS_COUNT', '%%COUNT%% Event|%%COUNT%% Events', array( '%%COUNT%%' => (int) $pageNav->total ) ) . '</span>';
		}

		initToolTip();

		$isModerator							=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner								=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus								=	CBGroupJive::getGroupStatus( $user, $group );
		$canCreate								=	CBGroupJive::canCreateGroupContent( $user, $group, 'events' );
		$canSearch								=	( $plugin->params->getBool( 'groups_events_search', true ) && ( $searching || $pageNav->total ) );
		$showAddress							=	$plugin->params->getBool( 'groups_events_address', true );
		$return									=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayEvents', array( &$return, &$rows, $group, $user ) );

		$return									.=	'<div class="gjGroupEvents">';

		if ( $canCreate || $canSearch ) {
			$return								.=		'<div class="row no-gutters mb-3 gjHeader gjGroupEventsHeader">';

			if ( $canCreate ) {
				$return							.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
												.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'new', 'group' => $group->getInt( 'id', 0 ) ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewEvent"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Event' ) . '</a>'
												.			'</div>';
			}

			if ( $canSearch ) {
				$return							.=			'<div class="col-12 ' . ( ! $canCreate ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
												.				'<form action="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupEventsSearchForm" class="m-0 gjGroupEventsSearchForm">'
												.					'<div class="input-group">'
												.						$input['search']
												.						'<div class="input-group-append">'
												.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
												.						'</div>'
												.					'</div>'
												.				'</form>'
												.			'</div>';
			}

			$return								.=		'</div>';
		}

		if ( $rows ) {
			$return								.=		'<div class="gjGroupEventsRows">';

			foreach ( $rows as $row ) {
				$rowOwner						=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$isModOrOwner					=	( $isModerator || $isOwner || $rowOwner || ( $userStatus >= 2 ) );
				$address						=	htmlspecialchars( $row->getString( 'location' ) );

				if ( $showAddress ) {
					if ( $row->getString( 'address' ) ) {
						$mapUrl					=	CBTxt::T( 'GROUP_EVENT_ADDRESS_MAP_URL', 'https://www.google.com/maps/place/[address]', array( '[location]' => urlencode( $row->getString( 'location' ) ), '[address]' => urlencode( $row->getString( 'address' ) ) ) );
					} else {
						$mapUrl					=	CBTxt::T( 'GROUP_EVENT_LOCATION_MAP_URL', 'https://www.google.com/maps/search/[location]', array( '[location]' => urlencode( $row->getString( 'location' ) ), '[address]' => urlencode( $row->getString( 'address' ) ) ) );
					}

					if ( $mapUrl ) {
						$address				=	'<a href="' . htmlspecialchars( $mapUrl ) . '" target="_blank" rel="nofollow">' . $address . '</a>';
					}
				}

				$menu							=	array();

				$integrations					=	implode( '', $_PLUGINS->trigger( 'gj_onDisplayEvent', array( &$row, &$menu, $group, $user ) ) );

				$canAttend						=	( ( $row->status() !== 1 )
														 && ( ! $row->getInt( '_attending', 0 ) )
														 && ( $user->getInt( 'id', 0 ) && ( ( $row->group()->getInt( 'type', 0 ) === 4 ) || ( $userStatus >= 1 ) ) )
														 && ( ( ! $row->getInt( 'limit', 0 ) ) || ( $row->getInt( 'limit', 0 ) && ( $row->getInt( '_guests', 0 ) < $row->getInt( 'limit', 0 ) ) ) )
													);
				$canMenu						=	( $isModOrOwner || ( ( ! $rowOwner ) && ( $row->status() !== 1 ) && ( $userStatus >= 1 ) && $row->getInt( '_attending', 0 ) ) || $menu );

				$return							.=			'<div class="row no-gutters mb-2 gjGroupEventsRow' . ( $row->status() === 1 ? ' gjGroupEventExpired' : ( $row->status() === 2 ? ' gjGroupEventActive' : null ) ) . '">'
												.				'<div class="col-md-2 d-none d-md-block pr-md-2 gjGroupEventCalendar">'
												.					'<div class="card text-center">'
												.						'<div class="card-body p-1 gjGroupEventMonth">' . cbFormatDate( $row->getString( 'start' ), true, false, 'M' ) . '</div>'
												.						'<div class="card-footer p-1 gjGroupEventDay">' . cbFormatDate( $row->getString( 'start' ), true, false, 'j' ) . '</div>'
												.					'</div>'
												.				'</div>'
												.				'<div class="col-12 col-md-10 gjGroupEventContainer">'
												.					'<div class="card' . ( $row->status() === 1 ? ' border-warning' : ( $row->status() === 2 ? ' border-primary' : null ) ) . '">'
												.						'<div class="card-header p-2 gjGroupEventHeader">'
												.							'<div class="row no-gutters align-items-center">'
												.								'<div class="order-0 col text-large text-center text-md-left gjGroupEventTitle">';

				if ( $isModOrOwner && ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'events', 1 ) === 2 ) ) ) {
					$return						.=									'<span class="gjGroupEventPendingIcon fa fa-lg fa-clock-o text-normal text-warning" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span> ';
				}

				$return							.=									htmlspecialchars( $row->getString( 'title' ) )
												.								'</div>';

				if ( $canAttend ) {
					$return						.=								'<div class="order-3 order-md-1 col-12 col-md-auto text-right mt-2 mt-md-0 gjGroupEventButtons">'
												.									'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'attend', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="btn btn-sm btn-success btn-md-block gjButton gjButtonAttend">' . CBTxt::T( 'Attend Event' ) . '</a>'
												.								'</div>';
				}

				if ( $canMenu ) {
					$return						.=								'<div class="order-2 col-auto text-right mr-n2 gjGroupEventMenu">';

					$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjEventMenuItems">';

					if ( ( $userStatus >= 1 ) && ( $row->status() !== 1 ) && $row->getInt( '_attending', 0 ) ) {
						$menuItems				.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you do not want to attend this Event?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'unattend', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unattend' ) . '</a></li>';
					}

					if ( $row->getInt( '_guests', 0 ) && ( $row->status() !== 1 ) && ( $isModerator || ( ( $row->getInt( 'published', 1 ) === 1 ) && $plugin->params->getBool( 'groups_events_message', false ) && ( $isOwner || ( $userStatus >= 3 ) ) ) ) ) {
						$delay					=	false;

						if ( ( ! $isModerator ) && $plugin->params->getInt( 'groups_events_message_delay', 60 ) && $row->params()->getString( 'messaged' ) ) {
							$seconds			=	$plugin->params->getInt( 'groups_events_message_delay', 60 );

							if ( $seconds && ( Application::Date( $row->params()->getString( 'messaged' ), 'UTC' )->add( $seconds . ' SECONDS' )->getTimestamp() >= Application::Date( 'now', 'UTC' )->getTimestamp() ) ) {
								$delay			=	true;
							}
						}

						if ( ! $delay ) {
							$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'message', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-comment"></span> ' . CBTxt::T( 'Message' ) . '</a></li>';
						}
					}

					if ( $isModOrOwner ) {
						$menuItems				.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 1 ) === -1 ) && ( $group->params()->getInt( 'events', 1 ) === 2 ) ) {
							if ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) {
								$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 1 ) === 1 ) {
							$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Event?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems				.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModOrOwner ) {
						$menuItems				.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Event?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems					.=	'</ul>';

					$return						.=									cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu gjEventMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' )
												.								'</div>';
				}

				$return							.=							'</div>'
												.						'</div>'
												.						'<div class="card-body p-2 text-small gjGroupEventDetails">';

				if ( $row->status() === 1 ) {
					$return						.=							'<div class="text-warning text-md-right gjGroupEventNotice">' . CBTxt::T( 'This event has ended.' ) . '</div>';
				} elseif ( $row->status() === 2 ) {
					if ( $row->getString( 'end' ) ) {
						$return					.=							'<div class="text-primary text-md-right gjGroupEventNotice">' . CBTxt::T( 'GROUP_EVENT_ENDS_IN', 'This event is currently in progress and ends in [timeago].', array( '[timeago]' => cbFormatDate( $row->getString( 'end' ), true, 'exacttimeago' ) ) ) . '</div>';
					} else {
						$return					.=							'<div class="text-primary text-md-right gjGroupEventNotice">' . CBTxt::T( 'This event is currently in progress.' ) . '</div>';
					}
				} else {
					$return						.=							'<div class="text-md-right gjGroupEventNotice">' . CBTxt::T( 'GROUP_EVENT_STARTS_IN', 'This event starts in [timeago].', array( '[timeago]' => cbFormatDate( $row->getString( 'start' ), true, 'exacttimeago' ) ) ) . '</div>';
				}

				$return							.=							'<div class="gjGroupEventDate">'
												.								'<span class="fa fa-clock-o text-center gjGroupEventIcon"></span> ' . $row->date()
												.							'</div>'
												.							'<div class="gjGroupEventLocation">'
												.								'<span class="fa fa-map-marker text-center gjGroupEventIcon"></span> ' . $address
												.							'</div>'
												.							'<div class="row no-gutters gjGroupEventAttending">'
												.								'<div class="col-md-6 gjGroupEventGuests">'
												.									'<span class="fa fa-users text-center gjGroupEventIcon"></span> '
												.									'<a href="' . htmlspecialchars( $_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'events', 'func' => 'attending', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '">'
												.										( $row->getInt( 'limit', 0 ) ? CBTxt::T( 'GROUP_GUESTS_COUNT_LIMITED', '%%COUNT%% of [limit] Guest|%%COUNT%% of [limit] Guests', array( '%%COUNT%%' => $row->getInt( '_guests', 0 ), '[limit]' => $row->getInt( 'limit', 0 ) ) ) : CBTxt::T( 'GROUP_GUESTS_COUNT', '%%COUNT%% Guest|%%COUNT%% Guests', array( '%%COUNT%%' => $row->getInt( '_guests', 0 ) ) ) )
												.									'</a>'
												.								'</div>'
												.								'<div class="col-md-6 text-md-right text-truncate gjGroupEventHost">'
												.									CBuser::getInstance( $row->getInt( 'user_id', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true )
												.								'</div>'
												.							'</div>'
												.						'</div>'
												.						'<div class="card-footer p-2 bg-transparent gjGroupEventDescription">'
												.							'<div class="cbMoreLess">'
												.								'<div class="cbMoreLessContent">'
												.									( $plugin->params->getBool( 'groups_events_content_plugins', false ) ? Application::Cms()->prepareHtmlContentPlugins( $row->getHtml( 'event' ), 'groupjive.event', $row->getInt( 'user_id', 0 ) ) : $row->getHtml( 'event' ) )
												.								'</div>'
												.								'<div class="fade-edge cbMoreLessOpen hidden">'
												.									'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'See More' ) . '</a>'
												.								'</div>'
												.							'</div>'
												.						'</div>'
												.						( $integrations ? '<div class="card-footer p-2 gjGroupEventFooter">' . $integrations . '</div>' : null )
												.					'</div>'
												.				'</div>'
												.			'</div>';
			}

			$return								.=		'</div>';

			if ( $plugin->params->getBool( 'groups_events_paging', true ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return							.=		'<div class="mt-3 gjGroupEventsPaging">'
												.			$pageNav->getListLinks()
												.		'</div>';
			}
		} else {
			$return								.=		'<div class="gjGroupEventsEmpty">';

			if ( $searching ) {
				$return							.=			CBTxt::T( 'No group event search results found.' );
			} else {
				$return							.=			CBTxt::T( 'This group currently has no events.' );
			}

			$return								.=		'</div>';
		}

		$return									.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayEvents', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}