<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\Table\GroupTable;
use Kunena\Forum\Libraries\Template\KunenaTemplate as Kunena6Template;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveForumsBacklink
{

	/**
	 * render frontend forum backlink
	 *
	 * @param GroupTable      $group
	 * @param object          $category
	 * @param string          $view
	 * @param Kunena6Template|KunenaTemplate $template
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showBacklink( $group, $category, $view, $template, $plugin )
	{
		global $_CB_framework;

		switch ( ( $template instanceof Kunena6Template ? $template->name : $template->get( 'name' ) ) ) {
			case 'aurelia':
				$button		=	'btn btn-outline-primary border';
				break;
			case 'crypsisb3':
				$button		=	'btn btn-default';
				break;
			case 'crypsisb4':
				$button		=	'btn border';
				break;
			case 'crypsis':
			default:
				$button		=	'btn';
				break;
		}

		switch ( $template->params->get( 'topicicontype' ) ) {
			case 'fa':
				$icon		=	'<span class="fa fa-undo" aria-hidden="true"></span> ';
				break;
			case 'B3':
				$icon		=	'<span class="glyphicon glyphicon-arrow-left" aria-hidden="true"></span> ';
				break;
			case 'B4':
			case 'B2':
			case 'image':
			default:
				$icon		=	'<i class="icon icon-backward-2" aria-hidden="true"></i> ';
				break;
		}

		if ( $view === 'category' ) {
			$button			.=	' kbutton-back-to-group';
		}

		return		( $view === 'topic' ? '<div class="btn-group">' : ' ' )
				.		'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" class="' . htmlspecialchars( $button ) . ' gjButton gjButtonBacklink">'
				.			$icon
				.			CBTxt::T( 'Back to Group' )
				.		'</a>'
				.	( $view === 'topic' ? '</div>' : null );
	}
}