<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveForums\Forum\Kunena;

use CBLib\Application\Application;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveForums\CBGroupJiveForums;
use Kunena\Forum\Libraries\Factory\KunenaFactory as Kunena6Factory;

defined('CBLIB') or die();

class KunenaTrigger extends \cbPluginHandler
{

	/**
	 * integrates with kunena
	 *
	 * @param string $event
	 * @param $config
	 * @param $params
	 */
	public function kunena( $event, &$config, &$params )
	{
		global $_CB_framework, $_CB_database;

		if ( ( ! CBGroupJiveForums::getForum() ) || ( CBGroupJiveForums::getForum()->type !== 'kunena' ) ) {
			return;
		}

		if ( $event === 'loadGroups' ) {
			$forum									=	CBGroupJiveForums::getForum();

			if ( ! $forum ) {
				return;
			}

			$options								=	array();

			if ( CBGroupJive::checkTooManyGroups() ) {
				$categoryId							=	$this->getInput()->getInt( 'catid', 0 );

				if ( ! $categoryId ) {
					return;
				}

				$category							=	$forum->getCategory( $categoryId );

				if ( ! $category->getInt( 'id', 0 ) ) {
					return;
				}

				$category							=	$category->category();

				if ( ( $category->get( 'accesstype' ) !== 'communitybuilder' ) || ( ! $category->get( 'access', 0 ) ) ) {
					return;
				}

				$group								=	CBGroupJive::getGroup( $category->get( 'access', 0 ) );

				if ( ! $group->getInt( 'id', 0 ) ) {
					return;
				}

				$option								=	new \stdClass();
				$option->id							=	$group->getInt( 'id', 0 );

				if ( $forum->version >= 6 ) {
					$option->parentid				=	0;
				} else {
					$option->parent_id				=	0;
				}

				$option->level						=	0;
				$option->name						=	$group->getString( 'name', '' );

				$options[$option->id]				=	$option;
			} else {
				$groups								=	CBGroupJive::getGroupOptions();

				foreach ( $groups as $group ) {
					$option							=	new \stdClass();
					$option->id						=	( is_array( $group->value ) ? uniqid( '', true ) : (int) $group->value );

					if ( $forum->version >= 6 ) {
						$option->parentid			=	0;
					} else {
						$option->parent_id			=	0;
					}

					$option->level					=	( is_array( $group->value ) ? 0 : 1 );
					$option->name					=	$group->text;

					$options[$option->id]			=	$option;
				}
			}

			$params['groups']						=	$options;
		} elseif ( $event === 'getAllowedForumsRead' ) {
			static $cache							=	array();

			$mydId									=	Application::MyUser()->getUserId();

			if ( ! $mydId ) {
				return;
			}

			if ( ! isset( $cache[$mydId] ) ) {
				$user								=	\CBuser::getMyUserDataInstance();
				$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );

				$sqlModes							=	array( 'owned', 'joined', 'pages' );
				$queries							=	array();

				foreach ( $sqlModes as $sqlMode ) {
					$query							=	'SELECT g.*'
													.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
													.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
													.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
													.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
													.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
													.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c"
													.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'category' );

					if ( $sqlMode === 'joined' ) {
						$query						.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
													.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
													.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
													.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 1 AND 3';
					}

					$query							.=	"\n WHERE cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
													.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
													.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

					switch ( $sqlMode ) {
						case 'joined':
							$query					.=	"\n AND u." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

							if ( ! $isModerator ) {
								$query				.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
													.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
													.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
													.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
							}
							break;
						case 'owned':
							$query					.=	"\n AND g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );

							if ( ! $isModerator ) {
								$query				.=	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
													.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
													.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
							}
							break;
						case 'pages':
							$query					.=	"\n AND g." . $_CB_database->NameQuote( 'user_id' ) . " != " . $user->getInt( 'id', 0 )
													.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " = 4";

							if ( ! $isModerator ) {
								$query				.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
													.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
													.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
													.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
							}
							break;
					}

					$queries[]						=	$query;
				}

				if ( count( $queries ) > 1 ) {
					$query							=	"SELECT * FROM ( " . implode( " UNION ALL ", $queries ) . " ) AS g";
				} else {
					$query							=	$queries[0];
				}

				$_CB_database->setQuery( $query );
				$groups								=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\GroupTable', array( $_CB_database ) );

				CBGroupJive::prefetchGroups( $groups );
				CBGroupJive::prefetchUsers( $groups );

				$allowed							=	array();

				/** @var GroupTable[] $groups */
				foreach ( $groups as $group ) {
					if ( $group->params()->getBool( 'forums', true ) ) {
						$froumId					=	$group->params()->getInt( 'forum_id', 0 );

						if ( $froumId && CBGroupJive::canCreateGroupContent( $user, $group, 'forums' ) ) {
							$allowed[]				=	$froumId;
						}
					}
				}

				$cache[$mydId]						=	$allowed;
			}

			if ( ! $cache[$mydId] ) {
				return;
			}

			$existingAccess							=	explode( ',', $params[1] );
			$cleanAccess							=	array_diff( $cache[$mydId], $existingAccess );
			$newAccess								=	array_merge( $existingAccess, $cleanAccess );

			cbArrayToInts( $newAccess );

			$params[1]								=	implode( ',', $newAccess );
		} elseif ( $event === 'authoriseUsers' ) {
			/** @var \KunenaForumCategory $category */
			$category								=	$params['category'];
			$groupId								=	$category->get( 'access', 0 );

			if ( ( ! $groupId ) || ( $category->get( 'accesstype' ) !== 'communitybuilder' ) ) {
				return;
			}

			$users									=	$params['userids'];

			if ( ! $users ) {
				return;
			}

			cbArrayToInts( $users );

			static $allowed							=	array();

			if ( ! isset( $allowed[$groupId] ) ) {
				$allowed[$groupId]					=	array();

				$group								=	CBGroupJive::getGroup( $groupId );

				if ( $group->getInt( 'type', 0 ) === 4 ) {
					$allowed[$groupId]				=	array();
				} elseif ( $group->getInt( 'id', 0 ) ) {
					$query							=	'SELECT u.' . $_CB_database->NameQuote( 'user_id' )
													.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
													.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
													.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
													.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
													.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
													.	"\n WHERE u." . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
													.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
													.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
													.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0"
													.	"\n AND u." . $_CB_database->NameQuote( 'status' ) . " >= 1";
					$_CB_database->setQuery( $query );
					$allowed[$groupId]				=	cbToArrayOfInt( $_CB_database->loadResultArray() );

					CBGroupJive::prefetchUsers( $allowed[$groupId] );
				}

				foreach ( $users as $userId ) {
					if ( ( ! in_array( $userId, $allowed[$groupId], true ) ) && CBGroupJive::isModerator( $userId ) ) {
						$allowed[$groupId][]		=	$userId;
					}
				}

				cbArrayToInts( $allowed[$groupId] );
			}

			if ( ! $allowed[$groupId] ) {
				return;
			}

			$notify									=	array();

			foreach ( $users as $userId ) {
				if ( in_array( $userId, $allowed[$groupId], true ) ) {
					$notify[]						=	$userId;
				}
			}

			if ( ! $notify ) {
				return;
			}

			$params['allow']						=	$notify;
		} elseif ( ( $event === 'loadCategoryRoles' )
				   && $this->params->getBool( 'groups_forums_back', true )
				   && ( in_array( $this->getInput()->getString( 'view' ), array( 'category', 'topic' ), true ) )
		) {
			static $backLinked						=	false;

			if ( $backLinked )  {
				return;
			}

			$backLinked								=	true;
			$categoryId								=	$this->getInput()->getInt( 'catid', 0 );

			if ( ! $categoryId ) {
				return;
			}

			$forum									=	CBGroupJiveForums::getForum();

			if ( ! $forum ) {
				return;
			}

			$category								=	$forum->getCategory( $categoryId );

			if ( ! $category->getInt( 'id', 0 ) ) {
				return;
			}

			$category								=	$category->category();

			if ( ( $category->get( 'accesstype' ) !== 'communitybuilder' ) || ( ! $category->get( 'access', 0 ) ) ) {
				return;
			}

			$group									=	CBGroupJive::getGroup( $category->get( 'access', 0 ) );

			if ( ! $group->getInt( 'id', 0 ) ) {
				return;
			}

			CBGroupJive::getTemplate( 'backlink', true, true, $this->element );

			$view									=	$this->getInput()->getString( 'view' );

			if ( $forum->version >= 6 ) {
				$template							=	Kunena6Factory::getTemplate();
			} else {
				$template							=	\KunenaFactory::getTemplate();
			}

			$backLink								=	json_encode( \HTML_groupjiveForumsBacklink::showBacklink( $group, $category, $view, $template, $this ), JSON_HEX_TAG );
			$js										=	null;

			switch ( $view ) {
				case 'category':
					$js								=	"$( '.kbutton-subscribe' ).each( function() {"
													.		"$( this ).after( $backLink );"
													.	"});";
					break;
				case 'topic':
					$js								=	"$( '#topic-actions-toolbar > div' ).each( function() {"
													.		"$( this ).append( $backLink );"
													.	"});";
					break;
			}

			$_CB_framework->outputCbJQuery( $js );
		}
	}
}