<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Notifications;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var NotificationTable $row
 * @var UserTable         $viewer
 * @var Notifications     $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $pinnedTooltip
 * @var string            $globalTooltip
 */

global $_CB_framework, $_PLUGINS;

$rowId				=	md5( $stream->id() . '_' . $row->getInt( 'id', 0 ) );

if ( $row->getBool( 'system', false ) ) {
	$title			=	$row->getHtml( 'title' );
	$message		=	$row->getHtml( 'message' );
} else {
	$title			=	htmlspecialchars( $row->getString( 'title' ) );
	$message		=	htmlspecialchars( $row->getString( 'message' ) );
}

$date				=	null;
$insert				=	null;
$footer				=	null;
$menu				=	array();

require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display', false );

$integrations		=	implode( '', $_PLUGINS->trigger( 'activity_onDisplayStreamNotification', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $output ) ) );

if ( $integrations ) {
	$footer			=	$integrations . $footer;
}

$title				=	$stream->parser( $title, $row )->parse( array( 'linebreaks' ) );
$message			=	$stream->parser( $message, $row )->parse();
?>
<div class="d-block card<?php echo ( $row->isGlobal( $stream ) ? ' border-info' : ( $row->isPinned( $stream ) ? ' border-warning' : ( ! $row->isRead( $stream ) ? ' border-primary' : null ) ) ) . ( CBActivity::findParamOverride( $row, 'inline', false ) ? ' border-0' : null ); ?> rounded-0 streamItem<?php echo ( CBActivity::findParamOverride( $row, 'compact', false ) ? ' streamItemCompact' : null ) . ( $row->isGlobal( $stream ) ? ' streamItemGlobal' : null ) . ( $row->isPinned( $stream ) ? ' streamItemPinned' : null ) . ( ! $row->isRead( $stream ) ? ' streamItemUnread' : null ); ?> streamPanel notificationContainer streamItem<?php echo $rowId; ?>" data-cbactivity-id="<?php echo $row->getInt( 'id', 0 ); ?>" data-cbactivity-timestamp="<?php echo Application::Date( $row->getString( 'date' ), 'UTC' )->getTimestamp(); ?>"<?php echo ( $row->getLink() ? ' data-cbactivity-link="' . htmlspecialchars( $row->getLink() ) . '"' : null ); ?>>
	<div class="card-header bg-transparent border-0 p-0 streamPanelHeading notificationContainerHeader">
		<div class="m-2<?php echo ( ! CBActivity::findParamOverride( $row, 'compact', false ) ? ' media streamMedia' : null ); ?> notificationContainerHeaderInner">
			<?php if ( ! CBActivity::findParamOverride( $row, 'compact', false ) ) { ?>
			<div class="media-left streamMediaLeft notificationContainerLogo">
				<?php echo CBActivity::getOwnerAvatar( $row ); ?>
			</div>
			<?php } ?>
			<div class="text-muted<?php echo ( ! CBActivity::findParamOverride( $row, 'compact', false ) ? ' media-body pl-2 pr-sm-5 streamMediaBody' : ' pr-sm-5' ); ?> notificationContainerTitle">
				<div class="text-wrap notificationContainerTitleTop">
					<?php echo CBActivity::getOwnerName( $row ); ?>
					<?php echo $title; ?>
				<?php if ( ! CBActivity::findParamOverride( $row, 'compact', false ) ) { ?>
				</div>
				<div class="text-small notificationContainerTitleBottom">
				<?php } ?>
					<?php echo cbTooltip( null, cbFormatDate( $row->getString( 'date' ) ), null, 'auto', null, cbFormatDate( $row->getString( 'date' ), true, 'timeago' ), null, 'data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' ); ?>
					<?php echo $date; ?>
				</div>
			</div>
		</div>
	</div>
	<?php if ( $message ) { ?>
	<div class="card-body p-0 streamPanelBody streamItemDisplay notificationContainerContent">
		<div class="m-2 notificationContainerContentInner cbMoreLess">
			<div class="text-wrap streamItemContent cbMoreLessContent clearfix">
				<?php echo $message; ?>
			</div>
			<div class="fade-edge cbMoreLessOpen hidden">
				<a href="javascript: void(0);" class="cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
			</div>
		</div>
	</div>
	<?php } ?>
	<?php if ( $insert ) { ?>
	<div class="card-body p-0 streamPanelBody streamItemDisplay notificationContainerInsert">
		<div class="<?php echo ( ! CBActivity::findParamOverride( $row, 'compact', false ) ? 'm-1 ' : null ); ?>notificationContainerInsertInner"><?php echo $insert; ?></div>
	</div>
	<?php } ?>
	<?php if ( CBActivity::findParamOverride( $row, 'links', true ) && $row->attachments()->count() ) { ?>
	<div class="card-body p-0 streamPanelBody streamItemDisplay notificationContainerAttachments">
		<div class="m-1 notificationContainerAttachmentsInner">
			<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/display', false ); ?>
		</div>
	</div>
	<?php } ?>
	<?php if ( $footer ) { ?>
	<div class="card-footer p-2 streamPanelFooter streamItemDisplay notificationContainerFooter">
		<div class="notificationContainerFooterInner"><?php echo $footer; ?></div>
	</div>
	<?php } ?>
	<div class="d-none d-sm-block position-absolute pr-2 pt-2 text-right streamItemMenu notificationContainerMenu">
		<?php if ( $row->isPinned( $stream ) ) { ?>
		<span class="fa fa-star text-warning streamItemPinnedIcon"<?php echo $pinnedTooltip; ?>></span>
		<?php } ?>
		<?php if ( $row->isGlobal( $stream ) ) { ?>
		<span class="fa fa-bullhorn text-info streamItemGlobalIcon"<?php echo $globalTooltip; ?>></span>
		<?php } ?>
		<?php echo implode( ' ', $menu ); ?>
		<?php if ( $viewer->getInt( 'id', 0 ) ) { ?>
			<?php if ( $row->isHidden() ) { ?>
			<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'unhide', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="notificationItemActionUnhide streamItemAction" data-cbactivity-container=".streamItem<?php echo $rowId; ?>"><?php echo CBTxt::T( 'Unhide' ); ?></a>
			<?php } elseif ( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user', 0 ) ) { ?>
			<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="notificationItemActionDelete streamItemAction" data-cbactivity-container=".streamItem<?php echo $rowId; ?>"><span class="fa fa-times"></span></a>
			<?php } else { ?>
			<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'hide', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="notificationItemActionHide streamItemAction" data-cbactivity-container=".streamItem<?php echo $rowId; ?>"><span class="fa fa-times"></span></a>
			<?php } ?>
		<?php } ?>
	</div>
	<?php echo ( $output === 'save' ? CBActivity::reloadHeaders() : null ); ?>
	<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-light streamLoading hidden"><div class="spinner-border spinner-border-sm"></div></div>
</div>
