<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable         $viewer
 * @var Notifications     $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var bool              $unread
 * @var int               $total
 * @var string            $layout
 * @var bool              $autoUpdate
 */

global $_CB_framework, $_PLUGINS;

$attributes			=	' data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '"';

if ( $autoUpdate ) {
	$attributes		.=	' data-cbactivity-autoupdate="true"';
}
?>
<span class="notificationsStreamButton streamBind streamContainer streamContainerButton stream<?php echo htmlspecialchars( $stream->id() ); ?>"<?php echo $attributes; ?>>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onBeforeDisplayNotificationsStreamButton', array( $total, $viewer, &$stream ) ) ); ?>
	<?php if ( $layout === 'toggle' ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'toggle', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="p-2 text-plain <?php echo ( ! $unread ? 'text-muted' : 'text-primary' ); ?> streamItemAction" data-cbactivity-container="stream" data-cbactivity-action-output="replace" data-cbactivity-action-target="stream">
		<span class="fa fa-lg fa-globe"></span>
		<?php echo ( $total ? CBActivity::getFormattedTotal( $total ) : null ); ?>
		<span class="streamLoading hidden"><span class="spinner-border spinner-border-sm text-secondary"></span></span>
	</a>
	<?php } else { ?>
	<a href="javascript: void(0);" class="p-2 d-none d-sm-inline-block text-plain <?php echo ( ! $unread ? 'text-muted' : 'text-primary' ); ?> cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-open-event="click" data-cbtooltip-close-event="click" data-cbtooltip-button-close="false" data-cbtooltip-width="auto" data-cbtooltip-height="auto" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad notificationsModalContainer" data-cbtooltip-open-classes="text-primary"<?php echo ( ! $unread ? ' data-cbtooltip-close-classes="text-muted"' : null ); ?> data-cbtooltip-content-classes="p-0">
		<span class="fa fa-lg fa-globe"></span>
		<?php echo ( $total ? CBActivity::getFormattedTotal( $total ) : null ); ?>
	</a>
	<a href="javascript: void(0);" class="p-2 d-inline-block d-sm-none text-plain <?php echo ( ! $unread ? 'text-muted' : 'text-primary' ); ?> cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-modal="true" data-cbtooltip-button-close="false" data-cbtooltip-width="90%" data-cbtooltip-height="90%" data-cbtooltip-open-solo=".notificationsModalContainer" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad notificationsModalContainer" data-cbtooltip-open-classes="text-primary"<?php echo ( ! $unread ? ' data-cbtooltip-close-classes="text-muted"' : null ); ?> data-cbtooltip-content-classes="p-0">
		<span class="fa fa-lg fa-globe"></span>
		<?php echo ( $total ? CBActivity::getFormattedTotal( $total ) : null ); ?>
	</a>
	<?php } ?>
	<?php if ( $autoUpdate ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'button', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="p-2 streamItemAction streamRefresh hidden" data-cbactivity-container="stream" data-cbactivity-action-output="replace" data-cbactivity-action-target="stream">
		<span class="fa fa-refresh"></span>
	</a>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayNotificationsStreamButton', array( $total, $viewer, $stream ) ) ); ?>
	<?php echo ( $output === 'refresh' ? CBActivity::reloadHeaders() : null ); ?>
</span>