<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Following;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable         $viewer
 * @var Following         $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $layout
 * @var bool              $following
 * @var bool              $canCreate
 * @var int               $total
 * @var array             $follows
 */

global $_CB_framework, $_PLUGINS;

$followerCount				=	null;

if ( $total ) {
	$followerCount			=	CBTxt::T( 'FOLLOWING_COUNT', '[followers] Follower|[followers] Followers|%%COUNT%%', array( '%%COUNT%%' => $total, '[followers]' => CBActivity::getFormattedTotal( $total ) ) );
}
?>
<span class="followStream<?php echo ( in_array( $layout, array( 'simple', 'extended' ), true ) ? ' followStreamSimple' : null ); ?> streamBind streamContainer stream<?php echo htmlspecialchars( $stream->id() ); ?>" data-cbactivity-stream="<?php echo htmlspecialchars( $stream->id() ); ?>">
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onBeforeDisplayStreamFollow', array( &$following, $total, $viewer, &$stream, $output ) ) ); ?>
	<?php if ( $canCreate ) { ?>
		<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'following/button', false ); ?>
	<?php } ?>
	<?php if ( $total ) { ?>
		<?php if ( in_array( $layout, array( 'simple', 'extended' ), true ) ) { ?>
		<span class="text-small followStreamCount streamCount">
			<a href="javascript: void(0);" class="<?php echo ( $canCreate ? 'text-muted ' : null ); ?>cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-title="<?php echo htmlspecialchars( $followerCount ); ?>" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".followingModalContainer" data-cbtooltip-width="800px" data-cbtooltip-height="600px" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad followingModalContainer" data-cbtooltip-content-classes="p-0">
				<?php echo ( ! $canCreate ? '<span class="fa fa-feed"></span> ' : null ); ?>
				<?php
				if ( ( $layout === 'extended' ) && $follows ) {
					$followCount		=	count( $follows );
					$followOne			=	'<span class="followStreamFollowed">' . array_shift( $follows ) . '</span>';
					$followTwo			=	'<span class="followStreamFollowed">' . array_shift( $follows ) . '</span>';

					if ( $followCount > 2 ) {
						echo CBTxt::T( 'FOLLOWING_MORE_THAN_TWO', '[follow_1], [follow_2], and [more] other followed this|[follow_1], [follow_2], and [more] others followed this|%%COUNT%%', array( '%%COUNT%%' => ( $total - 2 ), '[follow_1]' => $followOne, '[follow_2]' => $followTwo, '[more]' => CBActivity::getFormattedTotal( ( $total - 2 ) ) ) );
					} elseif ( $followCount > 1 ) {
						echo CBTxt::T( 'FOLLOWING_TWO', '[follow_1] and [follow_2] followed this', array( '[follow_1]' => $followOne, '[follow_2]' => $followTwo ) );
					} else {
						echo CBTxt::T( 'FOLLOWING_ONE', '[follow_1] followed this', array( '[follow_1]' => $followOne ) );
					}
				} else {
					echo CBActivity::getFormattedTotal( $total );
				}
				?>
			</a>
		</span>
		<?php } else { ?>
		<span class="position-relative align-middle text-small followStreamCount streamCount streamCountLabel">
			<?php echo ( $canCreate ? '<span class="position-absolute d-block border-right followStreamCountArrow streamCountLabelArrow"></span>' : null ); ?>
			<span class="d-inline-block border rounded bg-white text-center followStreamCountContent streamCountLabelContent">
				<a href="javascript: void(0);" class="d-block w-100 pl-3 pr-3 pt-1 pb-1<?php echo ( $canCreate ? ' text-muted' : null ); ?> cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'following', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-title="<?php echo htmlspecialchars( $followerCount ); ?>" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".followingModalContainer" data-cbtooltip-width="800px" data-cbtooltip-height="600px" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad followingModalContainer" data-cbtooltip-content-classes="p-0">
					<?php echo ( ! $canCreate ? '<span class="fa fa-feed"></span> ' : null ); ?>
					<?php echo CBActivity::getFormattedTotal( $total ); ?>
				</a>
			</span>
		</span>
		<?php } ?>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayStreamFollow', array( $following, $total, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( $output === 'save' ? CBActivity::reloadHeaders() : null ); ?>
</span>