<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CB\Plugin\PMS\PMSHelper;
use CB\Plugin\PMS\Table\MessageTable;
use CB\Plugin\PMS\UddeIM;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend PM notification
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */

global $_CB_framework, $_PLUGINS;

if ( ! $stream instanceof NotificationsInterface ) {
	return;
}

$id						=	(int) $matches[1];
$title					=	CBTxt::T( 'SENT_YOU_PRIVATE_MESSAGE', 'sent you a <a href="[url]">private message</a>', array( '[url]' => $_CB_framework->pluginClassUrl( 'pms.mypmspro', true, array( 'action' => 'message', 'func' => 'show', 'id' => $id ) ) ) );

$row->set( 'link', $_CB_framework->pluginClassUrl( 'pms.mypmspro', false, array( 'action' => 'message', 'func' => 'show', 'id' => $id ) ) );

if ( ( ! $_PLUGINS->getLoadedPlugin( 'user', 'pms.mypmspro' ) ) || ( ! class_exists( '\CB\Plugin\PMS\PMSHelper' ) ) ) {
	return;
}

if ( UddeIM::isUddeIM() ) {
	return;
}

/** @var MessageTable $pm */
$pm						=	$row->source();

if ( ( ! $pm ) || ( ! $pm->getInt( 'id', 0 ) ) ) {
	return;
}

$row->set( 'link', $_CB_framework->pluginClassUrl( 'pms.mypmspro', false, array( 'action' => 'message', 'func' => 'show', 'id' => $pm->getInt( 'id', 0 ), 'return' => PMSHelper::getReturn() ) ) );

$pmMessage				=	$pm->getMessage( 50 );

if ( $pmMessage ) {
	$title				=	CBTxt::T( 'SENT_YOU_PRIVATE_MESSAGE_TITLE', 'sent you private message <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->pluginClassUrl( 'pms.mypmspro', true, array( 'action' => 'message', 'func' => 'show', 'id' => $pm->getInt( 'id', 0 ), 'return' => PMSHelper::getReturn() ) ), '[title]' => $pmMessage ) );
}