<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveWall\Table\WallTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveWallEdit
{

	/**
	 * render frontend wall edit
	 *
	 * @param WallTable              $row
	 * @param array                  $input
	 * @param GroupTable             $group
	 * @param UserTable              $user
	 * @param CBplug_cbgroupjivewall $plugin
	 */
	public static function showWallEdit( $row, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$pageTitle					=	( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Edit Post' ) : CBTxt::T( 'New Post' ) );

		$_CB_framework->setPageTitle( $pageTitle );

		cbValidator::loadValidation();
		initToolTip();

		$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$canModerate				=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );
		$return						=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayWallEdit', array( &$return, &$row, &$input, $group, $user ) );

		$return						.=	'<div class="gjWallEdit">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'save', 'group' => ( ! $row->getInt( 'id', 0 ) ? $group->getInt( 'id' ) : null ), 'id' => $row->getInt( 'id', 0 ) ) ) . '" method="post" enctype="multipart/form-data" name="gjWallEditForm" id="gjWallEditForm" class="form-auto m-0 cb_form gjWallEditForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjWallEditTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null );

		if ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( $group->params()->getInt( 'wall', 1 ) !== 2 ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="published" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Published' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['published']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select publish state of this post. Unpublished posts will not be visible to the public.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( $row->reply()->getInt( 'id', 0 ) ) {
			$return					.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Reply' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$row->reply()->post()
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="post" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Post' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['post']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the post to share.' ) )
									.				'</div>'
									.			'</div>';

		if ( $isModerator ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="user_id" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Owner' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['user_id']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the post owner id. Post owner determines the creator of the post specified as User ID.' ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<input type="submit" value="' . htmlspecialchars( ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Update Post' ) : CBTxt::T( 'Post' ) ) ) . '" class="btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.					' <input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) ) . '\'; })" />'
									.				'</div>'
									.			'</div>'
									.			( ! $row->getInt( 'id', 0 ) ? '<input type="hidden" id="group" name="group" value="' . $group->getInt( 'id', 0 ) . '" />' : null )
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayWallEdit', array( &$return, $row, $input, $group, $user ) );

		echo $return;
	}
}