<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Invites\Trigger;

defined('CBLIB') or die();

class RouterTrigger extends \cbPluginHandler
{

	/**
	 * @param \ComprofilerRouter $router
	 * @param string             $plugin
	 * @param array              $segments
	 * @param array              $query
	 * @param \JMenuSite         $menuItem
	 */
	public function build( $router, $plugin, &$segments, &$query, &$menuItem )
	{
		if ( ( $plugin !== 'cbinvites' ) || ( ! $query ) || ( ! isset( $query['action'] ) ) ) {
			return;
		}

		unset( $query['action'] );

		if ( isset( $query['func'] ) ) {
			$func				=	$query['func'];

			unset( $query['func'] );

			if ( $func !== 'accept' ) {
				$segments[]		=	$func;

				if ( isset( $query['id'] ) ) {
					$segments[]	=	$query['id'];

					unset( $query['id'] );
				}
			} elseif ( isset( $query['code'] ) ) {
				$segments[]		=	$query['code'];

				unset( $query['code'] );
			}
		}
	}

	/**
	 * @param \ComprofilerRouter $router
	 * @param string             $plugin
	 * @param array              $segments
	 * @param array              $vars
	 * @param \JMenuSite         $menuItem
	 */
	public function parse( $router, $plugin, $segments, &$vars, $menuItem )
	{
		if ( ( $plugin !== 'cbinvites' ) || ( ! $segments ) ) {
			return;
		}

		$vars['action']			=	'invites';
		$func					=	( isset( $segments[0] ) ? $segments[0] : null );

		if ( in_array( $func, array( 'accept', 'link', 'email', 'send', 'delete' ), true ) ) {
			$vars['func']		=	$func;

			$id					=	( isset( $segments[1] ) ? $segments[1] : null );

			if ( $func === 'accept' ) {
				$vars['code']	=	$id;
			} else {
				$vars['id']		=	$id;
			}
		} elseif ( $func && ( strlen( $func ) === 32 ) ) {
			$vars['func']		=	'accept';
			$vars['code']		=	$func;
		}
	}
}